<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 * 
 ____  ____   __  _  _  __  _  _ 
(  _ \(  _ \ /  \( \/ )(  )( \/ )
 ) __/ )   /(  O ))  (  )( / \/ \
(__)  (__\_) \__/(_/\_)(__)\_)(_/
*/

define('PROX_DS', DIRECTORY_SEPARATOR);
define('PROX_NAMESPACE',          'Proxim');
define('PROX_DIR',                   dirname(__FILE__) . PROX_DS);
define('PROX_DIR_ROOT',              dirname(__DIR__) . PROX_DS);

define('PROX_DIR_INCLUDES',           PROX_DIR_ROOT . 'prox-includes' . PROX_DS);
define('PROX_DIR_CLASSES',            PROX_DIR_INCLUDES . 'classes' . PROX_DS);
define('PROX_DIR_CONTROLLERS',        PROX_DIR_INCLUDES . 'controllers' . PROX_DS);
define('PROX_DIR_CONTENT',            PROX_DIR_ROOT . 'content' . PROX_DS);
define('PROX_DIR_MODULE',              PROX_DIR_CONTENT . 'modules' . PROX_DS);

define('PROX_DIR_CACHE',              PROX_DIR . 'cache' . PROX_DS);
define('PROX_DIR_THEMES',             PROX_DIR . 'templates' . PROX_DS);

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once PROX_DIR_ROOT . 'config.php'; 
require_once PROX_DIR_ROOT . 'autoload.php';
require_once PROX_DIR . 'vendor' . PROX_DS . 'autoload.php';
require_once PROX_DIR . 'functions.php';

if (!defined('PROX_MAGIC_QUOTES_GPC')) {
    define('PROX_MAGIC_QUOTES_GPC', false);
}

use Proxim\Cache\CacheApcCore;
use Proxim\Cache\CacheMemcachedCore;
use Proxim\Configuration;
use Proxim\Database\DbCore;
use Proxim\Database\DbMySQLiCore;
use Proxim\Database\DbPDOCore;
use Proxim\Util\DateUtils;

abstract class Db extends DbCore {};
class DbPDO extends DbPDOCore {};
class DbMySQLi extends DbMySQLiCore {};
class CacheMemcached extends CacheMemcachedCore {};
class CacheApc extends CacheApcCore {};
use \VisualAppeal\AutoUpdate;

$version = '8.0.1';
if(file_exists(PROX_DIR . 'install' . PROX_DS . 'install-' . $version . '.php')) {
    include PROX_DIR . 'install' . PROX_DS . 'install-' . $version . '.php';
}