<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

use Proxim\Configuration;
use Proxim\Database\DbQuery;
use Proxim\Preference\AcademicLevel;
use Proxim\Util\DateUtils;

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS `prox_user_session` (
            `session_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `session_token` VARCHAR(64) NOT NULL,
            `user_id` BIGINT(20) UNSIGNED NOT NULL,
            `user_browser` VARCHAR(64) NOT NULL,
            `user_os` VARCHAR(64) NOT NULL,
            `user_ip` VARCHAR(64) NOT NULL,
            `date_add` DATETIME DEFAULT NULL,
            UNIQUE KEY `session_token` (`session_token`),
            KEY `user_ip` (`user_ip`),
        PRIMARY KEY(`session_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_order` ADD (
            `ordermanager_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `ordermanager_assigned` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `ordermanager_assigned_at` DATETIME DEFAULT NULL,
            `ordermanager_pay` FLOAT(14,2) DEFAULT 0.00,
            `is_ordermanager_paid` TINYINT(1) UNSIGNED DEFAULT '0',
            `ordermanager_paid_at` DATETIME DEFAULT NULL
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_order` ADD (
            `excel_sheets` INT(10) UNSIGNED NOT NULL DEFAULT '0'
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_order` ADD (
            `coupon_id` BIGINT(20) UNSIGNED DEFAULT NULL
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_employee` ADD (
            `number_of_takes` INT(10) UNSIGNED DEFAULT '0'
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_payment_request` ADD (
            `total_credit` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `total_fine` FLOAT(14,2) NOT NULL DEFAULT 0.00
        ); 
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_order_rating` ADD (
            `user_type` ENUM('customer', 'employee') NOT NULL default 'customer',
            `user_id` BIGINT(20) UNSIGNED DEFAULT NULL
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_order` ADD (
            `price_modifier` FLOAT(14,2) DEFAULT 0.00,
            `task_size_id` INT(10) UNSIGNED DEFAULT NULL,
            `task_item_price` FLOAT(14,2) DEFAULT 0.00,
            `software` VARCHAR(255) DEFAULT NULL,
            `words` INT(10) UNSIGNED DEFAULT '0',
            `keywords` VARCHAR(255) DEFAULT NULL,
            `price_per_word` FLOAT(14,4) DEFAULT 0.00,
            `english_type_id`  BIGINT(20) UNSIGNED DEFAULT NULL,
            `target_audience_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `writing_tone_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `writing_style_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `content_feel_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `is_pd_schedule_accepted` TINYINT(1) UNSIGNED NOT NULL default '0',
            `pd_schedule_accepted_at` DATETIME DEFAULT NULL,
            `is_pd_schedule_rejected` TINYINT(1) UNSIGNED NOT NULL default '0',
            `pd_schedule_rejected_at` DATETIME DEFAULT NULL
        ); 
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_discipline` ADD (
            `is_academic_writing` TINYINT(1) UNSIGNED NOT NULL DEFAULT '1',
            `is_calculations` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_programming` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_article_writing` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_deadline` ADD (
            `career_level_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `price_modifier` FLOAT(14,2) DEFAULT 0.00,
            `is_academic_writing` TINYINT(1) UNSIGNED NOT NULL DEFAULT '1',
            `is_calculations` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_programming` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_article_writing` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_resume` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_deadline` 
            MODIFY `academic_level_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            MODIFY `min_pages` INT(10) DEFAULT 1,
            MODIFY `price_per_page` FLOAT(14,4) DEFAULT 0.00;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_prepaper_payment` ADD (
            `order_id` BIGINT(20) UNSIGNED DEFAULT NULL
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_employee` ADD (
            `cpw_type` ENUM('system', 'custom') NOT NULL default 'system',
            `cpw_amount` FLOAT(14,4) NOT NULL DEFAULT 0.0000,
            `has_academic_access` TINYINT(1) UNSIGNED DEFAULT '1',
            `has_article_access` TINYINT(1) UNSIGNED DEFAULT '0',
            `has_programming_access` TINYINT(1) UNSIGNED DEFAULT '0',
            `has_calculations_access` TINYINT(1) UNSIGNED DEFAULT '0'
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_customer` ADD (
            `social_connected` TINYINT(1) UNSIGNED DEFAULT '0',
            `social_id` VARCHAR(255) DEFAULT NULL
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_paper_type` ADD (
            `is_academic_writing` TINYINT(1) UNSIGNED NOT NULL DEFAULT '1',
            `is_article_writing` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS `prox_mail_template` (
            `mail_template_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `template` VARCHAR(255) NOT NULL UNIQUE,
            `subject` TEXT DEFAULT NULL,
            `from_name` VARCHAR(255) DEFAULT NULL,
            `message` LONGTEXT DEFAULT NULL,
            `plaintext` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_disabled` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`mail_template_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS `prox_referral` (
            `referral_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `referrer_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `referree_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `code` VARCHAR(255) DEFAULT NULL,
            `amount` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `referrer_used` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `referree_used` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`referral_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS `prox_deliverable` (
            `deliverable_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `name` VARCHAR(255) NOT NULL,
            `slug` VARCHAR(255) NOT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`deliverable_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS `prox_descriptor` (
            `descriptor_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `discipline_id` BIGINT(20) UNSIGNED NOT NULL,
            `task_size_id` BIGINT(20) UNSIGNED NOT NULL,
            `example` TEXT NOT NULL,
            `is_calculations` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_programming` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`descriptor_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS `prox_descriptor_deliverable` (
            `descriptor_deliverable_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `descriptor_id` BIGINT(20) UNSIGNED NOT NULL,
            `deliverable_id` BIGINT(20) UNSIGNED NOT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`descriptor_deliverable_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS `prox_item_pricing` (
            `item_pricing_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `discipline_id` BIGINT(20) UNSIGNED NOT NULL,
            `task_size_id` BIGINT(20) UNSIGNED NOT NULL,
            `price` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `is_calculations` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_programming` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`item_pricing_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS `prox_english_type` (
            `english_type_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `title` VARCHAR(255) NOT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`english_type_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS `prox_target_audience` (
            `target_audience_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `title` VARCHAR(255) NOT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`target_audience_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS `prox_writing_tone` (
            `writing_tone_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `title` VARCHAR(255) NOT NULL,
            `description` TEXT DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`writing_tone_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS `prox_writing_style` (
            `writing_style_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `title` VARCHAR(255) NOT NULL,
            `description` TEXT DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`writing_style_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS `prox_content_feel` (
            `content_feel_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `title` VARCHAR(255) NOT NULL,
            `description` TEXT DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`content_feel_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    $deliverables = array(
        [
            'name' => 'Tables and charts', 
            'slug' => 'tables-and-charts'
        ],
        [
            'name' => 'Structure and flowcharts', 
            'slug' => 'structure-and-flowcharts'
        ],
        [
            'name' => 'Statistical scripts',
            'slug' => 'statistical-scripts'
        ],
        [
            'name' => 'Statistical models',
            'slug' => 'statistical-models'
        ],
        [
            'name' => 'Source code',
            'slug' => 'source-code'
        ],
        [
            'name' => 'Simple tables and charts',
            'slug' => 'simple-tables-and-charts'
        ],
        [
            'name' => 'Simple statistical models',
            'slug' => 'simple-statistical-models'
        ],
        [
            'name' => 'Simple queries and charts',
            'slug' => 'simple-queries-and-charts'
        ],
        [
            'name' => 'Simple operations and computations',
            'slug' => 'simple-operations-and-computations'
        ],
        [
            'name' => 'Simple drawings, tables and map filling',
            'slug' => 'simple-drawings-tables-map'
        ],
        [
            'name' => 'Simple database schema',
            'slug' => 'simple-database-schema'
        ],
        [
            'name' => 'Simple computations',
            'slug' => 'simple-computations'
        ],
        [
            'name' => 'Simple charts and diagrams',
            'slug' => 'simple-charts-and-diagrams'
        ],
        [
            'name' => 'Simple charts and calculations',
            'slug' => 'simple-charts-and-calculations'
        ],
        [
            'name' => 'Simple calculations',
            'slug' => 'simple-calculations'
        ],
        [
            'name' => 'Short answers to questions',
            'slug' => 'short-answers-to-questions'
        ],
        [
            'name' => 'Scripts and source code',
            'slug' => 'scripts-and-source-code'
        ],
        [
            'name' => 'Screenshots of outputs',
            'slug' => 'screenshots-of-outputs'
        ],
        [
            'name' => 'Problem analysis',
            'slug' => 'problem-analysis'
        ],
        [
            'name' => 'Presentation',
            'slug' => 'presentation'
        ],
        [
            'name' => 'Observations and forecasts',
            'slug' => 'observations-and-forecasts'
        ],
        [
            'name' => 'Models, drawings and charts',
            'slug' => 'models-drawings-and-charts'
        ],
        [
            'name' => 'Models, charts and calculations',
            'slug' => 'models-charts-and-calculations'
        ],
        [
            'name' => 'Map production',
            'slug' => 'map-production'
        ],
        [
            'name' => 'Simple 3D CAD model',
            'slug' => 'simple-3d-cad-model'
        ],
        [
            'name' => 'Experiment observations',
            'slug' => 'experiment-observations'
        ],
        [
            'name' => 'Drawings, tables and map filling',
            'slug' => 'drawings-tables-and-map-filling'
        ],
        [
            'name' => 'Documentation',
            'slug' => 'documentation'
        ],
        [
            'name' => 'Detailed report',
            'slug' => 'detailed-report'
        ],
        [
            'name' => 'Detailed explanations',
            'slug' => 'detailed-explanations'
        ],
        [
            'name' => 'Database schema',
            'slug' => 'database-schema'
        ],
        [
            'name' => 'Data schema with explanations',
            'slug' => 'data-schema-with-explanations'
        ],
        [
            'name' => 'Computations',
            'slug' => 'computations'
        ],
        [
            'name' => 'Complex models',
            'slug' => 'complex-models'
        ],
        [
            'name' => 'Charts and diagrams',
            'slug' => 'charts-and-diagrams'
        ],
        [
            'name' => 'Calculations',
            'slug' => 'calculations'
        ],
        [
            'name' => 'Brief report',
            'slug' => 'brief-report'
        ],
        [
            'name' => 'Advanced report (research proposal, dissertation/thesis chapter, etc.)',
            'slug' => 'advanced-report'
        ],
        [
            'name' => '3D CAD model',
            'slug' => '3d-cad-model'
        ]
    );

    foreach($deliverables as $deliverable) {
        $deliverableId = (int) Db::getInstance()->getValue('SELECT deliverable_id FROM ' . Db::prefix('deliverable') . ' WHERE slug =  \'' . pSQL($deliverable['slug']) . '\'');
        if($deliverableId) {
            Db::getInstance()->update(
                'deliverable',
                array(
                    'name' => $deliverable['name'],
                    'slug' => $deliverable['slug'],
                    'date_upd' => DateUtils::now()
                ),
                'deliverable_id = ' . (int) $deliverableId
            );
        } else {
            Db::getInstance()->insert(
                'deliverable',
                array(
                    'name' => $deliverable['name'],
                    'slug' => $deliverable['slug'],
                    'date_upd' => DateUtils::now(),
                    'date_add' => DateUtils::now(),
                )
            );
        }
    }
    
} catch (\Exception $e) {
    
}


try {
    $englishTypes = array(
        'English US',
        'English UK'
    );
    
    foreach($englishTypes as $englishType) {
        $englishTypeId = (int) Db::getInstance()->getValue('SELECT english_type_id FROM ' . Db::prefix('english_type') . ' WHERE title =  \'' . pSQL($englishType) . '\'');
        if($englishTypeId) {
            Db::getInstance()->update(
                'english_type',
                array(
                    'title' => $englishType,
                    'date_upd' => DateUtils::now()
                ),
                'english_type_id = ' . (int) $englishTypeId
            );
        } else {
            Db::getInstance()->insert(
                'english_type',
                array(
                    'title' => $englishType,
                    'date_upd' => DateUtils::now(),
                    'date_add' => DateUtils::now(),
                )
            );
        }
    }
    
} catch (\Exception $e) {
    
}


try {
    $targetAudiences = array(
        'Businesses',
        'General Audience'
    );
    
    foreach($targetAudiences as $targetAudience) {
        $targetAudienceId = (int) Db::getInstance()->getValue('SELECT target_audience_id FROM ' . Db::prefix('target_audience') . ' WHERE title =  \'' . pSQL($targetAudience) . '\'');
        if($targetAudienceId) {
            Db::getInstance()->update(
                'target_audience',
                array(
                    'title' => $targetAudience,
                    'date_upd' => DateUtils::now()
                ),
                'target_audience_id = ' . (int) $targetAudienceId
            );
        } else {
            Db::getInstance()->insert(
                'target_audience',
                array(
                    'title' => $targetAudience,
                    'date_upd' => DateUtils::now(),
                    'date_add' => DateUtils::now(),
                )
            );
        }
    }
    
} catch (\Exception $e) {
    
}

try {
    $writingTones = array(
        [
            'title' => 'Informal',
            'description' => 'Informal, chatty, and familiar'
        ],
        [
            'title' => 'Formal',
            'description' => 'Corporate tone that\'s all business'  
        ],
        [
            'title' => 'Business Casual',
            'description' => 'Friendly with a professional tone'
        ]
    );
    
    foreach($writingTones as $writingTone) {
        $writingToneId = (int) Db::getInstance()->getValue('SELECT writing_tone_id FROM ' . Db::prefix('writing_tone') . ' WHERE title =  \'' . pSQL($writingTone['title']) . '\'');
        if($writingToneId) {
            Db::getInstance()->update(
                'writing_tone',
                array(
                    'title' => $writingTone['title'],
                    'description' => $writingTone['description'],
                    'date_upd' => DateUtils::now()
                ),
                'writing_tone_id = ' . (int) $writingToneId
            );
        } else {
            Db::getInstance()->insert(
                'writing_tone',
                array(
                    'title' => $writingTone['title'],
                    'description' => $writingTone['description'],
                    'date_upd' => DateUtils::now(),
                    'date_add' => DateUtils::now(),
                )
            );
        }
    }
} catch (\Exception $e) {
    
}

try {
    $writingStyles = array(
        [
            'title' => 'Informational',
            'description' => 'Entirely impartial and purely informational content'
        ],
        [
            'title' => 'Promotional',
            'description' => 'Content that overtly promotes your products or services'
        ]
    );
    
    foreach($writingStyles as $writingStyle) {
        $writingStyleId = (int) Db::getInstance()->getValue('SELECT writing_style_id FROM ' . Db::prefix('writing_style') . ' WHERE title =  \'' . pSQL($writingStyle['title']) . '\'');
        if($writingStyleId) {
            Db::getInstance()->update(
                'writing_style',
                array(
                    'title' => $writingStyle['title'],
                    'description' => $writingStyle['description'],
                    'date_upd' => DateUtils::now()
                ),
                'writing_style_id = ' . (int) $writingStyleId
            );
        } else {
            Db::getInstance()->insert(
                'writing_style',
                array(
                    'title' => $writingStyle['title'],
                    'description' => $writingStyle['description'],
                    'date_upd' => DateUtils::now(),
                    'date_add' => DateUtils::now(),
                )
            );
        }
    }
} catch (\Exception $e) {
    
}

try {
    $contentFeels = array(
        [
            'title' => 'Evergreen',
            'description' => 'Long lasting content that feels "current" all year round'
        ],
        [
            'title' => 'Newsy',
            'description' => 'Mentions current events, but feels dated after a while'  
        ]
    );
    
    foreach($contentFeels as $contentFeel) {
        $contentFeelId = (int) Db::getInstance()->getValue('SELECT content_feel_id FROM ' . Db::prefix('content_feel') . ' WHERE title =  \'' . pSQL($contentFeel['title']) . '\'');
        if($contentFeelId) {
            Db::getInstance()->update(
                'content_feel',
                array(
                    'title' => $contentFeel['title'],
                    'description' => $contentFeel['description'],
                    'date_upd' => DateUtils::now()
                ),
                'content_feel_id = ' . (int) $contentFeelId
            );
        } else {
            Db::getInstance()->insert(
                'content_feel',
                array(
                    'title' => $contentFeel['title'],
                    'description' => $contentFeel['description'],
                    'date_upd' => DateUtils::now(),
                    'date_add' => DateUtils::now(),
                )
            );
        }
        
    }
    
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->update(
        'order',
        array(
            'service_type' => 52,
        ),
        'order_type = "article"'
    );
} catch (\Exception $e) {
    
}

try {
    if(Configuration::get('WALLET_ENABLED')) {
        $tablesUpdated = false;
        $result = Db::getInstance()->getRow("SELECT * FROM ". Db::prefix('wallet_transaction'));
        if(!isset($result['customer_id'])) {
            $tablesUpdated = true;

            Db::getInstance()->Execute("ALTER TABLE " . Db::prefix('wallet_transaction') . " CHANGE wallet_id customer_id BIGINT(20);");
        }

        $result = Db::getInstance()->getRow("SELECT * FROM ". Db::prefix('customer'));
        if(!isset($result['wallet_balance'])) {
            $tablesUpdated = true;

            Db::getInstance()->Execute("
                ALTER TABLE " . Db::prefix('customer') . " ADD (
                    `wallet_balance` FLOAT(14,2) NOT NULL DEFAULT 0.00
                );
            ");
        }

        if($tablesUpdated) {
            $walletTransactions = Db::getInstance()->executeS("SELECT * FROM ". Db::prefix('wallet_transaction'));

            foreach($walletTransactions as $walletTransaction) {
                $transactionWallet = Db::getInstance()->getRow("SELECT * FROM ". Db::prefix('customer_wallet') . " WHERE wallet_id = " . (int) $walletTransaction['customer_id']);
                // update transaction customer_id
                Db::getInstance()->update(
                    'wallet_transaction',
                    array(
                        'customer_id' => $transactionWallet['customer_id'],
                    ),
                    'wallet_transaction_id = ' . (int) $walletTransaction['wallet_transaction_id']
                );

                // update balance
                Db::getInstance()->update(
                    'customer',
                    array(
                        'wallet_balance' => $transactionWallet['wallet_balance'],
                    ),
                    'customer_id = ' . (int) $transactionWallet['customer_id']
                );
            }
        }
    }
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE " . Db::prefix('order') . " ADD (
            `is_new_customer` TINYINT(1) UNSIGNED NOT NULL default '0'
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE " . Db::prefix('order') . " ADD (
            `current_writer_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `current_editor_id` BIGINT(20) UNSIGNED DEFAULT NULL
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS " . Db::prefix('order_employee') . " (
            `order_employee_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `order_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `employee_type` ENUM('writer', 'editor', 'ordermanager') NOT NULL default 'writer',
            `employee_id` BIGINT(20) UNSIGNED NOT NULL,
            `hrs_employee` INT(10) UNSIGNED NOT NULL DEFAULT '0',
            `employee_deadline` DATETIME DEFAULT NULL,
            `employee_pay` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `is_employee_paid` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `employee_paid_at` DATETIME DEFAULT NULL,
            `is_auto_assigned` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_employee_assigned` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `employee_assigned_at` DATETIME DEFAULT NULL,
            `is_employee_confirmed` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `employee_confirmed_at` DATETIME DEFAULT NULL,
            `is_employee_declined` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `employee_declined_at` DATETIME DEFAULT NULL,
            `is_completed` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_delivered` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_approved` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_cancelled` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_revised` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_disputed` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_refunded` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_late` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`order_employee_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS " . Db::prefix('employee_pool') . " (
            `employee_pool_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `name` VARCHAR(155) DEFAULT NULL,
            `description` TEXT DEFAULT NULL,
            `color` VARCHAR(64) DEFAULT NULL,
            `badge` TEXT DEFAULT NULL,
            `requirements` LONGTEXT DEFAULT NULL,
            `benefits` LONGTEXT DEFAULT NULL,
            `status` ENUM('active', 'disabled', 'hidden') NOT NULL default 'active',
            `rating` INT(10) NOT NULL DEFAULT 0,
            `order` INT(10) NOT NULL DEFAULT '0',
            `urgent_orders` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `new_customers` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `auto_delivery` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `base_price` INT(10) NOT NULL DEFAULT 0,
            `price_per_page` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `price_per_word` FLOAT(14,4) NOT NULL DEFAULT 0.00,
            `academic_level` INT(10) NOT NULL,
            `writer_category` INT(10) NOT NULL,
            `takes` INT(10) NOT NULL DEFAULT 0,
            `bids` INT(10) NOT NULL DEFAULT 0,
            `is_default` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
            PRIMARY KEY(`employee_pool_id`)
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE " . Db::prefix('employee') . " ADD (
            `employee_pool_id` BIGINT(20) UNSIGNED DEFAULT NULL
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE " . Db::prefix('customer') . " ADD (
            `total_orders` INT(10) NOT NULL DEFAULT 0,
            `employee_pool_id` BIGINT(20) UNSIGNED DEFAULT NULL
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE " . Db::prefix('order') . "  
            MODIFY `pages` DECIMAL(5,1);
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE " . Db::prefix('coupon') . "  
            MODIFY `coupon_code` VARCHAR(255) NOT NULL;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE " . Db::prefix('employee') . " ADD (
            `country` VARCHAR(10) DEFAULT NULL,
            `city` VARCHAR(255) DEFAULT NULL,
            `highest_academic_degree` VARCHAR(64) DEFAULT NULL,
            `academic_degree_major` TEXT DEFAULT NULL,
            `software` TEXT DEFAULT NULL, 
            `proficient_disciplines` TEXT DEFAULT NULL,
            `native_language` VARCHAR(255) DEFAULT NULL,
            `other_languages` TEXT DEFAULT NULL,
            `date_of_birth` DATE DEFAULT NULL,
            `referrer_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `referrer_source` VARCHAR(255) DEFAULT NULL,
            `affiliate_used` TINYINT(1) UNSIGNED NOT NULL default '0',
            `affiliate_balance` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `is_application_completed` TINYINT(1) UNSIGNED NOT NULL default '0',
            `available_247` TINYINT(1) UNSIGNED NOT NULL default '0',
            `available_urgent_orders` TINYINT(1) UNSIGNED NOT NULL default '0',
            `is_profile_completed` TINYINT(1) UNSIGNED NOT NULL default '0',
            
            /** Guide **/
            `is_guide_complete` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `guide_completed_at` DATETIME DEFAULT NULL,
        
            /** Writing Prompt **/
            `is_writingprompt_started` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `writingprompt_started_at` DATETIME DEFAULT NULL,
            `writing_prompt_question` TEXT DEFAULT NULL,
            `writing_prompt_answer` TEXT DEFAULT NULL,
            `is_writingprompt_complete` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `writingprompt_completed_at` DATETIME DEFAULT NULL,
            
            /** Essay **/
            `is_essay_complete` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `application_essays_ids` TEXT DEFAULT NULL,
            `essay_completed_at` DATETIME DEFAULT NULL,
        
            /** Samples **/
            `is_samples_complete` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `samples_completed_at` DATETIME DEFAULT NULL,
        
            /** CV **/
            `is_cv_complete` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `cv_completed_at` DATETIME DEFAULT NULL,
        
            /** Degree Cert **/
            `is_degree_cert_complete` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `degree_cert_completed_at` DATETIME DEFAULT NULL,
        
            /** Application Status **/
            `is_application_approved` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `application_approved_at` DATETIME DEFAULT NULL,
            `is_application_rejected` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0', 
            `application_rejected_at` DATETIME DEFAULT NULL,
            `is_application_locked` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `application_locked_at` DATETIME DEFAULT NULL
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS  " . Db::prefix('employee_file') . " (
            `employee_file_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `employee_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `uploader_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `handle` VARCHAR(255) NOT NULL,
            `description` VARCHAR(255) DEFAULT NULL,
            `name` VARCHAR(255) NOT NULL,
            `size` INT(10) NOT NULL DEFAULT '0',
            `source` TEXT NOT NULL,
            `extension` VARCHAR(20) DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`employee_file_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS " . Db::prefix('writing_guide') . " (
            `writing_guide_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `type` VARCHAR(20) NOT NULL,
            `title` VARCHAR(255) NOT NULL,
            `guide` TEXT DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`writing_guide_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS " . Db::prefix('writing_prompt') . " (
            `writing_prompt_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `title` VARCHAR(255) NOT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`writing_prompt_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS " . Db::prefix('application_essay') . " (
            `application_essay_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `title` VARCHAR(255) NOT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`application_essay_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS " . Db::prefix('software_programming') . " (
            `software_programming_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `title` VARCHAR(255) NOT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`software_programming_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        ALTER TABLE " . Db::prefix('order_tip') . " ADD (
            `writer_tip_amount` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `editor_tip_amount` FLOAT(14,2) NOT NULL DEFAULT 0.00
        );
    ");
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS " . Db::prefix("fine_type") . " ( 
            `fine_type_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `name` VARCHAR(155) NOT NULL,
            `type` enum('percentage', 'amount') NOT NULL,
            `value` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`fine_type_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {
    
}

try {
    $sql = new DbQuery();
    $sql->select('c.customer_id');
    $sql->from('customer', 'c');
    $customers = Db::getInstance()->executeS($sql);

    foreach($customers as $customer) {
        $orderCount = Db::getInstance(PROX_USE_SQL_SLAVE)->getValue('SELECT COUNT(*) as orders FROM ' . Db::prefix('order') . ' WHERE is_paid = 1 AND customer_id = ' . (int) $customer['customer_id']);
        Db::getInstance()->update('customer', ['total_orders' => $orderCount ], 'customer_id = '. (int) $customer['customer_id'] );
    }
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->execute("
        ALTER TABLE `prox_customer` ADD (
            `is_anonymous` TINYINT(1) UNSIGNED NOT NULL default '0',
            `anonymous_id_saved` TINYINT(1) UNSIGNED NOT NULL default '0'
        );
    "); 
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->execute("
        CREATE TABLE IF NOT EXISTS `prox_academic_level` (
            `academic_level_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `title` VARCHAR(255) NOT NULL,
            `short_title` VARCHAR(255) DEFAULT NULL,
            `degree` VARCHAR(255) DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`academic_level_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    "); 
} catch (\Exception $e) {
    
}

try {
    Db::getInstance()->execute("
        CREATE TABLE IF NOT EXISTS `prox_academic_level_site` (
            `academic_level_id` BIGINT(20) UNSIGNED NOT NULL,
            `site_id` BIGINT(20) UNSIGNED NOT NULL,
            PRIMARY KEY (`academic_level_id`, `site_id`),
            KEY `site_id` (`site_id`)
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    "); 
} catch (\Exception $e) {
    
}

try {
    /** Academic Level HighSchool **/
    define('LEVEL_HIGHSCHOOL', 1);
    /** Academic Level Undergrad. (yrs 1‑2) **/
    define('LEVEL_COLLEGE', 2);
    /** Academic Level Undergrad. (yrs 3‑4) **/
    define('LEVEL_UNIVERSITY', 3);
    /** Academic Level Master's **/
    define('LEVEL_MASTERS', 4);
    /** Academic Level PhD **/
    define('LEVEL_PHD', 5);

    $academicLevels = array(
        LEVEL_HIGHSCHOOL => [
            "short_title" => "High school",
            "title" => "High school",
            "degree" => "Highschool Diploma"
        ],
        LEVEL_COLLEGE => [
            "short_title" => "College",
            "title" => "Undergrad. (yrs 1-2)",
            "degree" => "Associate's degree"
        ],
        LEVEL_UNIVERSITY => [
            "short_title" => "University",
            "title" => "Undergrad. (yrs 3-4)",
            "degree" => "Bachelor's degree"
        ],
        LEVEL_MASTERS => [
            "short_title" => "Master's",
            "title" => "Master's",
            "degree" => "Master's degree"
        ],
        LEVEL_PHD => [
            "short_title" => "Ph.D.",
            "title" => "PhD",
            "degree" => "Doctoral degree"
        ]
    );

    foreach($academicLevels as $academicLevelId => $academicLevel) {
        $academicLevelId = (int) Db::getInstance()->getValue('SELECT academic_level_id FROM ' . Db::prefix('academic_level') . ' WHERE title =  \'' . pSQL($academicLevel['title']) . '\'');
        $insert = true;

        if(!$academicLevelId) {
            Db::getInstance()->insert(
                'academic_level',
                array(
                    'title' => pSQL($academicLevel['title']),
                    'short_title' => pSQL($academicLevel['short_title']),
                    'degree' => pSQL($academicLevel['degree']),
                    'date_upd' => DateUtils::now(),
                    'date_add' => DateUtils::now(),
                )
            );
        }
        
    }
} catch (\Exception $e) {
    
}

