<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

$db_structure = "
/* Installed module list */
CREATE TABLE IF NOT EXISTS `prox_module` (
    `module_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(64) NOT NULL,
    `active` TINYINT(1) unsigned NOT NULL DEFAULT '0',
    `version` VARCHAR(8) NOT NULL,
    PRIMARY KEY (`module_id`),
    UNIQUE KEY `name_UNIQUE` (`name`),
    KEY `name` (`name`)
) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE IF NOT EXISTS `prox_hook` (
    `hook_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(64) NOT NULL,
    `title` VARCHAR(64) NOT NULL,
    `description` TEXT,
    `position` TINYINT(1) NOT NULL DEFAULT '1',
    PRIMARY KEY (`hook_id`),
    UNIQUE KEY `hook_name` (`name`)
) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

/* Hook alias name */
CREATE TABLE IF NOT EXISTS `prox_hook_alias` (
    `hook_id_alias` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
    `alias` VARCHAR(64) NOT NULL,
    `name` VARCHAR(64) NOT NULL,
    PRIMARY KEY (`hook_id_alias`),
    UNIQUE KEY `alias` (`alias`)
) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

/* Define registered hook module */
CREATE TABLE IF NOT EXISTS `prox_hook_module` (
    `module_id` BIGINT(20) unsigned NOT NULL,
    `hook_id` BIGINT(20) unsigned NOT NULL,
    `position` TINYINT(2) unsigned NOT NULL,
    PRIMARY KEY (
        `module_id`, `hook_id`
    ),
    KEY `hook_id` (`hook_id`),
    KEY `module_id` (`module_id`),
    KEY `position` (`position`)
) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
";

if (Db::getInstance()->Execute($db_structure)) {
    try {

        $sql = "
            INSERT INTO `prox_hook` VALUES (1,'displayAdminEditSiteNavbar','displayAdminEditSiteNavbar','',1),(2,'displayAdminEditSiteNavContent','displayAdminEditSiteNavContent','',1),(3,'actionBeforeUpdateSiteSettings','actionBeforeUpdateSiteSettings','',1),(4,'paymentOptions','paymentOptions','',1),(5,'displayAdminNavBarBeforeStart','displayAdminNavBarBeforeStart','',1),(6,'displayFooterAfter','displayFooterAfter','',1),(7,'displayJsAfter','displayJsAfter','',1),(8,'displayClientHeader','displayClientHeader','',1),(9,'displayClientFooter','displayClientFooter','',1),(10,'displayAdminNavBarSettings','displayAdminNavBarSettings','',1),(11,'displayAdminModuleNav','displayAdminModuleNav','',1),(12,'verifyPayment','verifyPayment','',1),(13,'displayOrderAdditionalInfo','displayOrderAdditionalInfo','',1),(14,'displayAdminNavBarBeforeEnd','displayAdminNavBarBeforeEnd','',1),(15,'displayAdminEditCustomerNavbar','displayAdminEditCustomerNavbar','',1),(16,'displayAdminEditCustomerNavContent','displayAdminEditCustomerNavContent','',1),(18,'actionBeforeAdminDelete','actionBeforeAdminDelete','',1);

            INSERT INTO `prox_hook_module` VALUES (73,12,1),(103,14,1),(89,12,2),(115,12,3),(68,4,4),(68,8,4),(68,9,4),(73,4,5),(73,8,5),(73,9,5),(89,4,6),(89,8,6),(89,9,6),(115,4,7),(115,8,7),(115,9,7);

            INSERT INTO `prox_module` VALUES (68,'safepay',1,'1.0.0'),(73,'stripe',1,'1.0.0'),(89,'securetrading',1,'1.0.0'),(115,'paypal',1,'1.0.0');
        ";
        Db::getInstance()->Execute($sql);

    } catch(\Exception $e) {

    }
   
}