/**
 * core js
 *
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

// initialize API URLs
var {
    api_path,
    theme_mode_night
} = proxim;

/**
 * Date formatter with PHP "date()"-compatible format syntax.
 */
const formatDate = (format, date) => {
    if (!format) { format = 'Y-m-d' }
    if (!date) { date = new Date() }

    const parts = {
      Y: date.getFullYear().toString(),
      y: ('00' + (date.getYear() - 100)).toString().slice(-2),
      m: ('0' + (date.getMonth() + 1)).toString().slice(-2),
      n: (date.getMonth() + 1).toString(),
      d: ('0' + date.getDate()).toString().slice(-2),
      j: date.getDate().toString(),
      H: ('0' + date.getHours()).toString().slice(-2),
      G: date.getHours().toString(),
      i: ('0' + date.getMinutes()).toString().slice(-2),
      s: ('0' + date.getSeconds()).toString().slice(-2)
    }

    const modifiers = Object.keys(parts).join('')
    const reDate = new RegExp('(?<!\\\\)[' + modifiers + ']', 'g')
    const reEscape = new RegExp('\\\\([' + modifiers + '])', 'g')

    return format
      .replace(reDate, $0 => parts[$0])
      .replace(reEscape, ($0, $1) => $1)
}

// initialize the plugins
function initialize() {
    // run bootstrap tooltip
    $('body').tooltip({
        selector: '[data-toggle="tooltip"], [data-tooltip=tooltip]'
    });

    $('[data-toggle="popover"]').length && $('[data-toggle="popover"]').popover()

    // run autosize (expand textarea) plugin
    autosize($('.js_autosize'));

    $('.select_search').select2();

    // run slimScroll plugin
    $('.js_scroller').each(function(){
        var _this = $(this);
        /* return if the plugin already running  */
        if(_this.parent('.slimScrollDiv').length > 0) {
            return;
        }
        /* run if not */
        _this.slimScroll({
            height: _this.attr('data-slimScroll-height') || '280px',
            start: _this.attr('data-slimScroll-start') || 'top',
            distance: '2px'
        })
    });

    // init datetimepicker plugin
    if($(".js_datetimepicker").length > 0) {
        $('.js_datetimepicker').datetimepicker({
            format: "DD-MM-YYYY HH:mm",
            locale: $('html').attr('lang').split("_", 1).toString() || 'en'
        });
    }

    // Timezone handler
    $(document).on("change", "#timezone-region", function(){
        var value = $(this).val(),
            $timezone_combo = $("#timezone-combo-"+value);
        $timezone_combo.find("option:first").prop("selected", true);
        $("[data-content=timezone]").val($timezone_combo.val()).change();
    });

    $(document).on("change", "[id^=timezone-combo-]", function(){
        var value = $(this).val();
        $("[data-content=timezone]").val(value).change();
    });

    // Co-combo breaker
    $(document).on("change", "select[data-combo]", function(){
        var $combo = $("#"+$(this).data("combo"));

        if($combo.length) {
            $combo.children(".switch-combo").hide();
        }
        var $combo_container = $("#" + $(this).closest("select").data("combo")),
            $combo_target = $("[data-combo-value~=" + $("option:selected", this).attr("value") + "]", $combo_container);

        if($combo_target.length){
            $combo_target
                .show()
                .find("[data-required]")
                .each(function() {
                    $(this).attr("required", "required"); // re-enable any disabled required
                });
        }

        $('.select_search').select2();

        // Disable [required] in hidden combos
        $(".switch-combo", $combo_container).each(function() {
            if($(this).is(":visible")) return;
            $("[required]", this).attr("data-required", true).removeAttr("required");
        });
    });

    // run moment plugin
    $(".js_moment").each(function(){
        var _this = $(this);
        var time = _this.data('time');

        var time = new Date( time );
        if ( Number.isNaN(Date.parse(time)) ) {
            _this.text('N/A');
            return;
        }

        _this.text( dateFormat(time+' UTC', 'mmm d, yyyy \'at\' h:MM TT') );
    });
}

// modal
function modal() {
    if(arguments[0] == "#modal-login") {
        /* disable the backdrop (don't close modal when click outside) */
        if($('#modal').data('bs.modal')) {
            $('#modal').data('bs.modal').options = {backdrop: 'static', keyboard: false};
        } else {
            $('#modal').modal({backdrop: 'static', keyboard: false});
        }
    }
    /* check if the modal not visible, show it */
    if(!$('#modal').is(":visible")) $('#modal').modal('show');
    /* prepare modal size */
    $('.modal-dialog').removeClass('modal-sm');
    $('.modal-dialog').removeClass('modal-lg');
    $('.modal-dialog').removeClass('modal-xlg');

    switch(arguments[2]) {
        case 'small':
            $('.modal-dialog').addClass('modal-sm');
            break;
        case 'large':
            $('.modal-dialog').addClass('modal-lg');
            break;
        case 'extra-large':
            $('.modal-dialog').addClass('modal-xl');
            break;
    }

    /* update the modal-content with the rendered template */
    $('.modal-content:last').html( render_template(arguments[0], arguments[1]) );
    /* initialize modal if the function defined (user logged in) */
    if(typeof initialize_modal === "function") {
        initialize_modal();
    }
}

// confirm
function confirm(title, message, callback) {
    modal('#modal-confirm', {'title': title, 'message': message});
    $("#modal-confirm-ok").click( function() {
        $(this).prop('disabled', true);
        $(this).html('Loading...');
        if(callback) callback();
    });
}


// render template
function render_template(selector, options) {
    var template = $(selector).html();
    Mustache.parse(template);
    var rendered_template = Mustache.render(template, options);
    return rendered_template;
}

// button status
function button_status(element, handle) {
    if(handle == "loading") {
        /* loading */
        element.data('text', element.html());
        element.prop('disabled', true);
        element.html('<span class="spinner-grow spinner-grow-sm mr10"></span> Loading');
    } else {
        /* reset */
        element.prop('disabled', false);
        element.html(element.data('text'));
    }
}

$(function() {

    // init plugins
    initialize();
    $(document).ajaxComplete(function() {
        initialize();
    });

    // init fastlink plugin
    FastClick.attach(document.body);

    // init offcanvas-sidebar
    $('[data-toggle=offcanvas]').click(function() {
        $('.offcanvas').toggleClass('active');
    });

    // run bootstrap modal
    $('body').on('click', '[data-toggle="modal"]', function(e) {
        e.preventDefault();
        if($(e.target).hasClass('link') && $(e.target).hasClass('disabled')) {
            return false;
        }
        var url = $(this).data('url');
        var options = $(this).data('options');
        var size = $(this).data('size') || "default";
        if (url.indexOf('#') == 0) {
            /* open already loaded modal with #id */
            modal(url, options, size);
        } else {
            /* get & load modal from url */
            $.getJSON(api_path+url, function(response) {
                /* check the response */
                if(!response) return;
                /* check if there is a callback */
                if(response.callback) {
                    eval(response.callback);
                }
            })
            .fail(function() {
                modal('#modal-message', {title: 'Error', message: 'There is something that went wrong!'});
            });
        }
    });

    // bootsrap dropdown keep open (and for slimScrollBar)
    $(document).on('click', '.js_dropdown-keepopen, .slimScrollBar', function (e) {
        e.stopPropagation();
    });

    // run bootstrap btn-group
    $(document).on('click', '.btn-group a', function (e) {
        e.preventDefault();
        var parent = $(this).parents('.btn-group');
        /* change the value */
        parent.find('input[type="hidden"]').val($(this).data('value'));
        /* copy text to btn-group-text */
        parent.find('.btn-group-text').text($(this).text());
        /* copy icon to btn-group-icon */
        parent.find('.btn-group-icon').attr("class", $(this).find('i.fa').attr("class")).addClass('btn-group-icon');
        /* copy title to tooltip */
        parent.data('original-title', $(this).data('title'));
        parent.data('value', $(this).data('value'));
        parent.tooltip();
    });

    // run toggle-panel
    $('.js_toggle-panel').click(function(event){
        event.preventDefault;
        var parent = $(this).parents('.js_panel');
        parent.hide();
        parent.siblings().fadeIn();
        return false;
    }); 

    // run ajax-forms
    $(document).on('submit', '.js_ajax-forms', function(e) {
        e.preventDefault();
        var url =  $(this).data('url');
        var submit =  $(this).find('button[type="submit"]');
        var error =  $(this).find('.alert.alert-danger');
        var success =  $(this).find('.alert.alert-success');
        /* show any collapsed section if any */
        if( $(this).find('.js_hidden-section').length > 0 && ! $(this).find('.js_hidden-section').is(':visible')) {
             $(this).find('.js_hidden-section').slideDown();
            return false;
        }
        /* show loading */
        submit.data('text', submit.html());
        submit.prop('disabled', true);
        submit.html('Loading');
        /* get ajax response */
        $.post(api_path+url, $(this).serialize(), function(response) {
            /* hide loading */
            submit.prop('disabled', false);
            submit.html(submit.data('text'));
            /* handle response */
            if(response.error) {
                if(success.is(":visible")) success.hide(); // hide previous alert
                error.html(response.message).slideDown();
            } else if(response.success) {
                if(error.is(":visible")) error.hide(); // hide previous alert
                success.html(response.message).slideDown();
            } else {
                eval(response.callback);
            }
        }, "json")
        .fail(function() {
            /* hide loading */
            submit.prop('disabled', false);
            submit.html(submit.data('text'));
            /* handle error */
            if(success.is(":visible")) success.hide(); // hide previous alert
            error.html('There is something that went wrong!').slideDown();
        });
    });

    $('body').on('click', '.js_theme-mode', function () {
        _this = $(this);
        mode = _this.data('mode');
        if(mode == "night") {
            $('body').addClass('night-mode');
            $('.table').addClass('table-dark');
            _this.data('mode', 'day');
            $('.js_theme-mode-text').text('Day Mode');
            $('.js_theme-mode-icon').removeClass("fa-moon").addClass("fa-sun");
            $.post(api_path+'/theme', {'mode': mode});

        } else {
            $('body').removeClass('night-mode');
            $('.table').removeClass('table-dark');
            _this.data('mode', 'night');
            $('.js_theme-mode-text').text('Night Mode');
            $('.js_theme-mode-icon').removeClass("fa-sun").addClass("fa-moon");
            $.post(api_path+'/theme', {'mode': mode});
        }
    });
});
