/**
 * core js
 * 
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

// initialize API URLs
var {
    api_path
} = proxim;

$(function() {

    // run colorpicker plugin
    $('.js_colorpicker').colorpicker({
        format: 'hex'
    });

    $(document).on('click', '.js_select-all', function (e) {
        if(this.checked) {
            // Iterate each checkbox
            $('[name="bulk_action"]').each(function() {
                this.checked = true;                        
            });
        } else {
            $('[name="bulk_action"]').each(function() {
                this.checked = false;                       
            });
        }
    });

    $(document).on('click', '.js_bulk-actions', function (e) {
        e.preventDefault();
        var table = $(this).parents('.table-responsive').find('tbody');
        let orderIds = [];

        table.find('tr [name="bulk_action"]:checked').each(function() {
            orderIds.push( parseInt($(this).val()) );
        });

        if(orderIds.length == 0) {
            return modal('#modal-error', {title: 'Error', message: 'Select at least one order'});
        }

        modal("#modal-bulk-actions", {
            orderIds: JSON.stringify(orderIds)
        });
    });
    
    $(document).on('click', '.js_mark-as-paid', function (e) {
        e.preventDefault();
        var oid = $(this).data('oid');

        confirm('Mark as Paid', 'This order is unpaid. Are you sure you want mark this order as paid?.', function() {
            $.post(api_path +'/orders/'+oid+'/mark-as-paid', {'do': 'mark-as-paid'} , function(response) {
                if(response.callback) {
                    eval(response.callback);
                }

                window.location.reload;
            }, 'json')
            .fail(function() {
                modal('#modal-message', {title: 'Error', message: 'There is something that went wrong!'});
            });
        });
    });

    // run admin deleter
    $(document).on('click', '.js_deleter', function () {
        var handle = $(this).data('handle');
        var id = $(this).data('id');
        var node = $(this).data('node');
        confirm('Delete', 'Are you sure you want to delete this?', function() {
            $.post(api_path+'/admin/delete', {'handle': handle, 'id': id, 'node': node}, function(response) {
                /* check the response */
                if(response.callback) {
                    eval(response.callback);
                } else {
                    window.location.reload();
                }
            }, 'json')
            .fail(function() {
                modal('#modal-message', {title: 'Error', message: 'There is something that went wrong!'});
            });
        });
    });

    // run admin tester
    $(document).on('click', '.js_admin-tester', function () {
        var _this = $(this);
        var _parent = _this.parents('form');
        var error =  _parent.find('.alert.alert-danger');
        var success =  _parent.find('.alert.alert-success');
        var handle = _this.data('handle');
        /* show loading */
        _this.data('text', _this.html());
        _this.prop('disabled', true);
        _this.html('Loading');
        $.post(api_path+'/admin/test', {'handle': handle}, function(response) {
            /* hide loading */
            _this.prop('disabled', false);
            _this.html(_this.data('text'));
            /* handle response */
            if(response.error) {
                if(success.is(":visible")) success.hide(); // hide previous alert
                error.html(response.message).slideDown();
            } else if(response.success) {
                if(error.is(":visible")) error.hide(); // hide previous alert
                success.html(response.message).slideDown();
            } else {
                eval(response.callback);
            }
        }, 'json')
        .fail(function() {
            /* hide loading */
            _this.prop('disabled', false);
            _this.html(_this.data('text'));
            /* handle error */
            if(success.is(":visible")) success.hide(); // hide previous alert
            error.html('There is something that went wrong!').slideDown();
        });
    });

    // run admin withdraw
    $(document).on('click', '.js_admin-withdraw', function () {
        var handle = $(this).data('handle');
        var id = $(this).data('id');
        if(handle == "approve") {
            var _title = 'Mark as Paid';
            var _message = 'Are you sure you want to approve this request?';
        } else {
            var _title = 'Decline';
            var _message = 'Are you sure you want to decline this request?';
        }

        confirm(_title, _message, function() {
            $.post(api_path+'/admin/withdraw', {'handle': handle, 'id': id}, function(response) {
                /* check the response */
                if(response.callback) {
                    eval(response.callback);
                } else {
                    window.location.reload();
                }
            }, 'json')
            .fail(function() {
                modal('#modal-message', {title: 'Error', message: 'There is something that went wrong!'});
            });
        });
    });

    $(document).on('click', '.js_reset-password-link', function () {
        var id = $(this).data('id');
        var handle = $(this).data('handle');

        $.post(api_path+'/admin/password-reset-link', {'handle': handle, 'id': id}, function(response) {
            /* check the response */
            if(response.callback) {
                eval(response.callback);
            } else {
                window.location.reload();
            }
        }, 'json')
        .fail(function() {
            modal('#modal-message', {title: 'Error', message: 'There is something that went wrong!'});
        });
    });

    /* install module */
    $(document).on('click', '.js_install-module', function () {
        var _this = $(this);
        var module_name = _this.data('module');
        /* button loading */
        button_status(_this, "loading");

        /* post the request */
        $.post(api_path+'/admin/modules', {'do': 'install', 'module_name': module_name} , function(response) {
            if(response.callback) {
                /* button reset */
                button_status(_this, "reset");
                eval(response.callback);
            } else {
                _this.replaceWith('<button type="button" class="btn btn-sm btn-secondary pull-right js_uninstall-module" data-module="'+module_name+'">Uninstall</button>');
            }
        }, "json") 
        .fail(function() {
            /* button reset */
            button_status(_this, "reset");
            modal('#modal-message', {title: 'Error', message: 'There is something that went wrong!'});
        });
    });

    /* uninstall module */
    $(document).on('click', '.js_uninstall-module', function (e) {
        e.preventDefault();
        var _this = $(this);
        var module_name = _this.data('module');
        var uninstall_message = _this.data('message') || 'Are you sure you want to uninstall this module?';
        
        confirm('Uninstall Module', uninstall_message, function () {
            /* button loading */
            button_status(_this, "loading");

            $.post(api_path+'/admin/modules', {'do': 'uninstall', 'module_name': module_name} , function(response) {
                /* hide the confimation */
                $('#modal').modal('hide');

                if (response.callback) {
                    /* button reset */
                    button_status(_this, "reset");
                    eval(response.callback);
                } else {
                    _this.replaceWith('<button type="button" class="btn btn-sm btn-success pull-right js_install-module" data-module="'+module_name+'">Install</button>');
                }
            }, 'json')
                .fail(function () {
                    modal('#modal-message', { title: 'Error', message: 'There is something that went wrong!' });
                });
        });
    });
    
});