<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Dashboard;

use Db;
use Proxim\Configuration;
use Proxim\Controller;
use Proxim\Database\DbQuery;
use Proxim\Util\DateUtils;
use Proxim\Util\ArrayUtils;

class Updates extends Controller {
    public function index() {
        $app = $this->app;
        $user = $app->user;
        $smarty = $app->smarty;
        $params = $app->request->get();

        $this->setVars([
            'page_title' => "System Updates"
        ]);

        $last_version_check = Configuration::get('PROX_LAST_VERSION_CHECK');

        $update_available = $check_for_update = false;

        if(ArrayUtils::has($params, 'force-check')) {
            $check_for_update = true;
            $update = $app->checkVersion( true );
            if($update) {
                $update_available = true;
                $smarty->assign([
                    'new_update_version' => $update['version']
                ]);
            }
        }

        $sql = new DbQuery();
        $sql->select('site.*');
        $sql->from('site', 'site');
        $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql);

        $sites = array();
        foreach($result as $site) {
            $sites[] = array(
                'id' => $site['site_id'],
                'name' => $site['name'],
                'domain' => $site['domain'],
                'version' => Configuration::get('PROX_VERSION', $site['site_id']),
                'last_update' => Configuration::get('PROX_LAST_UPDATE', $site['site_id']),
            );
        }

        $smarty->assign([
            'view' => 'updates',
            'sites' => $sites,
            'check_for_update' => $check_for_update,
            'update_available' => $update_available,
            'last_version_check' => DateUtils::date($last_version_check, null, 'M jS, Y \\a\\t g:i A') 
        ]);

        $this->setTemplate('dashboard/system/updates');
        $this->display(); 
    }
}