<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Dashboard;

use Db;
use Proxim\Controller;
use Proxim\Database\DbQuery;
use Proxim\Mail;
use Proxim\Configuration;
use Proxim\Hook;
use Proxim\Preference\Discipline;
use Proxim\Preference\WritingGuide;
use Proxim\User\Employee;
use Proxim\Validate;
use Proxim\Tools;
use Proxim\Util\DateUtils;
use Proxim\Util\ArrayUtils;

class PWA extends Controller {
    public function manifest() {
        $app = $this->app;
        $user = $app->user;

        $pwa_app_icon = Configuration::get('PWA_APP_ICON');
        $icon_info = explode('.', $pwa_app_icon);
        $icon_url = $app->base_uri .'/uploads/'. $icon_info[0];
        $icon_ext = $icon_info[1];

        $manifest = [
            "name" => Configuration::get('PWA_APP_NAME'),
            "short_name" => Configuration::get('PWA_SHORT_NAME'),
            "start_url" => "/login",
            "display" => "standalone",
            "scope" => "/",
            "background_color" => Configuration::get('PWA_BACKGROUND_COLOR'),
            "theme_color" => Configuration::get('PWA_THEME_COLOR'),
            "orientation" => "portrait",
            "icons" => [
                [
                    "src" => $icon_url . '-72x72.' . $icon_ext,
                    "type" => "image/png",
                    "sizes" => "72x72",
                    "purpose" => "any maskable",
                ],
                [
                    "src" => $icon_url . '-96x96.' . $icon_ext,
                    "type" => "image/png",
                    "sizes" => "96x96",
                    "purpose" => "any maskable",
                ],
                [
                    "src" => $icon_url . '-128x128.' . $icon_ext,
                    "type" => "image/png",
                    "sizes" => "128x128",
                    "purpose" => "any maskable",
                ],
                [
                    "src" => $icon_url . '-144x144.' . $icon_ext,
                    "type" => "image/png",
                    "sizes" => "144x144",
                    "purpose" => "any maskable",
                ],
                [
                    "src" => $icon_url . '-152x152.' . $icon_ext,
                    "type" => "image/png",
                    "sizes" => "152x152",
                    "purpose" => "any maskable",
                ],
                [
                    "src" => $icon_url . '-192x192.' . $icon_ext,
                    "type" => "image/png",
                    "sizes" => "192x192",
                    "purpose" => "any maskable",
                ],
                [
                    "src" => $icon_url . '-384x384.' . $icon_ext,
                    "type" => "image/png",
                    "sizes" => "384x384",
                    "purpose" => "any maskable",
                ],
                [
                    "src" => $icon_url . '-512x512.' . $icon_ext,
                    "type" => "image/png",
                    "sizes" => "512x512",
                    "purpose" => "any maskable",
                ],
            ],
        ];

        return $this->response($manifest);
    }

    public function serviceWorker() {
        $app = $this->app;
        $smarty = $app->smarty; 
        $user = $app->user;

        $themeDir = '/content/themes/' . PROX_ACTIVE_THEME;

        $this->registerStylesheet('dashlite', $themeDir . '/css/dashlite.css');
        $this->registerStylesheet('theme', $themeDir . '/css/skins/theme.css');
        $this->registerStylesheet('theme-blue', $themeDir . '/css/skins/theme-blue.css');
        $this->registerStylesheet('theme-bluelite', $themeDir . '/css/skins/theme-bluelite.css');
        $this->registerStylesheet('theme-egyptian', $themeDir . '/css/skins/theme-egyptian.css');
        $this->registerStylesheet('theme-green', $themeDir . '/css/skins/theme-green.css');
        $this->registerStylesheet('theme-red', $themeDir . '/css/skins/theme-red.css');
        $this->registerStylesheet('fontawesome', $themeDir . '/css/libs/fontawesome-icons.css');
    
        $this->registerStylesheet('colorpicker', $themeDir . '/js/plugins/bootstrap.colorpicker/bootstrap-colorpicker.min.css');
        $this->registerStylesheet('datetimepicker', $themeDir . '/js/plugins/bootstrap.datetimepicker/bootstrap-datetimepicker.min.css');
        $this->registerStylesheet('intlTelInput', $themeDir . '/css/intl.telinput/intlTelInput.css');
        $this->registerStylesheet('quill', $themeDir . '/css/editors/quill.css');
        $this->registerStylesheet('summernote', $themeDir . '/css/editors/summernote.css');


        $this->registerJavascript('scripts', $themeDir . '/js/scripts.js');
        $this->registerJavascript('customize', $themeDir . '/js/customize.js');
        $this->registerJavascript('jquery.form', $themeDir . '/js/plugins/jquery.form/jquery.form.min.js');
        $this->registerJavascript('eventemmiter', $themeDir . '/js/eventemmiter/eventemitter.js');
        $this->registerJavascript('mustache', $themeDir . '/js/mustache/mustache.min.js');
        $this->registerJavascript('intl.telinput', $themeDir . '/js/plugins/intl.telinput/intlTelInput.min.js');
        $this->registerJavascript('fastclick', $themeDir . '/js/plugins/fastclick/fastclick.min.js');
        $this->registerJavascript('jquery.slimscroll', $themeDir . '/js/plugins/jquery.slimscroll/jquery.slimscroll.min.js');
        $this->registerJavascript('autosize', $themeDir . '/js/plugins/autosize/autosize.min.js');
        $this->registerJavascript('moment', $themeDir . '/js/plugins/moment/moment-with-locales.min.js');
        $this->registerJavascript('themmoment-timezone-with-datae', $themeDir . '/js/plugins/moment/moment-timezone-with-data.js');
        $this->registerJavascript('dateformat', $themeDir . '/js/plugins/dateformat/dateformat.js');
        $this->registerJavascript('bootstrap-datetimepicker', $themeDir . '/js/plugins/bootstrap.datetimepicker/bootstrap-datetimepicker.min.js');
        $this->registerJavascript('quill', $themeDir . '/js/libs/editors/quill.js');
        $this->registerJavascript('summernote', $themeDir . '/js/libs/editors/summernote.js');
        $this->registerJavascript('bootstrap.colorpicker', $themeDir . '/js/plugins/bootstrap.colorpicker/bootstrap-colorpicker.min.js');
        $this->registerJavascript('calculator', $themeDir . '/js/proxim/calculator.js');
        $this->registerJavascript('core', $themeDir . '/js/proxim/core.js');
        $this->registerJavascript('user', $themeDir . '/js/proxim/user.js');

        if($user->is_admin) {
            $this->registerJavascript('theme', $themeDir . '/js/proxim/admin.js');
        }

        $javascript = $this->getJavascript();
        $stylesheets = $this->getStylesheets();

        $javascriptList = $stylesheetsList = array();
        foreach($stylesheets['external'] as $id => $css) {
            $stylesheetsList[] = $css['uri'];
        }

        foreach($javascript['bottom']['external'] as $id => $js) {
            $javascriptList[] = $js['uri'];
        }

        $mediaList = array_merge($stylesheetsList, $javascriptList);

        $smarty->assign([
            'mediaList' => $mediaList
        ]);
        $serviceWorkerJs = $smarty->fetch("serviceWorker.tpl");

        $response = $app->response;
        $response->header('Content-Type', 'text/javascript; charset=utf-8');
        return $response->setBody($serviceWorkerJs);
    }
    
}