<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Dashboard;

use Db;
use Proxim\Database\DbQuery;
use Proxim\Controller;
use Proxim\Pager;
use Proxim\Currency;
use Proxim\Coupon;
use Proxim\Site\Site;
use Proxim\Configuration;
use Proxim\User\Customer;
use Proxim\User\Employee;
use Proxim\Validate;
use Proxim\Tools;
use Proxim\Util\DateUtils;
use Proxim\Util\ArrayUtils;

class Overview extends Controller {

    public function overview() {
        $app = $this->app;
        $user = $app->user;
        $smarty = $app->smarty;

        if($user->is_sub_admin) {
            $this->setTemplate('404');
            $this->display();
        }

        $this->setVars([
            'page_title' => "Overview"
        ]);

        $this->setTemplate('dashboard/overview');
        $this->display(); 

    }
}