<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Dashboard;

use Db;
use Proxim\Controller;
use Proxim\Database\DbQuery;
use Proxim\Mail;
use Proxim\Configuration;
use Proxim\Hook;
use Proxim\Preference\AcademicLevel;
use Proxim\Preference\Discipline;
use Proxim\Preference\WritingGuide;
use Proxim\User\Employee;
use Proxim\Validate;
use Proxim\Tools;
use Proxim\Util\DateUtils;
use Proxim\Util\ArrayUtils;

class Onboarding extends Controller {
    public function started() {
        global $globals;
        $app = $this->app;
        $user = $app->user;
        $smarty = $app->smarty; 

        if(!$user->is_applicant && $user->is_started) {
            $app->redirect('/orders');
        }

        if($user->is_profile_completed) {
            $app->redirect('/application');
        }

        $this->setVars([
            'page_title' => "Getting Started"
        ]);

        // languages
        $languages = languages();

        $disciplineGroups = Discipline::getDisciplinesByGroup();

        # softwares & programming
        $sql = new DbQuery();
        $sql->select('sp.*');
        $sql->from('software_programming', 'sp');
        $sql->orderBy('sp.software_programming_id DESC');
        $software_programming = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql);

        $academicLevels = AcademicLevel::getAcademicLevels();

        $smarty->assign([
            'view' => 'profile',
            'languages' => $languages,
            'disciplineGroups' => $disciplineGroups,
            'software_programming' => $software_programming,
            'academicDegrees' => $academicLevels,
            'countries' => $globals['countries']
        ]);

        $this->setTemplate('dashboard/apply/started');
        $this->display();
    } 

    public function application( $view = 'test' ) {
        global $globals;
        $app = $this->app;
        $user = $app->user;
        $smarty = $app->smarty;

        if(!$user->is_applicant && $user->is_started) {
            $app->redirect('/orders');
        }

        switch($view) {
            case 'test':
                $this->setVars([
                    'page_title' => "Application Test"
                ]);
                break;

            case 'guide':
                if($user->is_guide_complete) {
                    return $app->redirect('/application');
                }

                $this->setVars([
                    'page_title' => "Writing Guide"
                ]);

                $writing_guides = WritingGuide::getWritingGuides();

                $smarty->assign([
                    'writing_guides' => $writing_guides
                ]);
                break;

            case 'writing':
                if($user->is_writingprompt_complete) {
                    return $app->redirect('/application');
                }

                if(!$user->is_writingprompt_started) {
                    $user->is_writingprompt_started = 1;
                    $user->writingprompt_started_at = DateUtils::now();
                    $user->update();
                }

                $writing_prompts = Db::getInstance()->executeS('SELECT wp.* FROM ' . Db::prefix('writing_prompt') . ' AS wp ORDER BY RAND() LIMIT 2');

                $this->setVars([
                    'page_title' => "Writing Prompt"
                ]);

                $smarty->assign([
                    'writing_prompts' => $writing_prompts,
                    'writingprompt_started_at' => DateUtils::convertToISOFormat($user->writingprompt_started_at)
                ]);
                break;

            default:
                $this->setTemplate('404');
                $this->display();
                break;
        }

        $essays = $application_essays_ids = array();
        $current_step = 'guide';

        if($user->is_guide_complete) {
            $current_step = 'writingprompt';
        }

        if($user->is_writingprompt_complete) {
            $current_step = 'essay';

            if(!$user->application_essays_ids) {
                $essays = Db::getInstance()->executeS('SELECT ae.* FROM ' . Db::prefix('application_essay') . ' AS ae ORDER BY RAND() LIMIT 2');

                foreach($essays as $essay) {
                    $application_essays_ids[] = (int) $essay['application_essay_id'];
                }
                $user->application_essays_ids = implode(',', $application_essays_ids);
                $user->update();
            } else {
                $application_essays_ids = explode(',', $user->application_essays_ids);
                $sql = 'SELECT ae.* FROM ' . Db::prefix('application_essay') . ' AS ae WHERE ae.application_essay_id IN ('.implode(',', $application_essays_ids).')';
                $essays = Db::getInstance()->executeS($sql);
            }
        }

        if($user->is_samples_complete || $user->is_essay_complete) {
            $current_step = 'education_upload';
        }

        if($user->is_cv_complete) {
            $current_step = 'education_upload';
        }

        $smarty->assign([
            'essays' => $essays,
            'current_step' => $current_step,
            'view' => $view
        ]);
        
        $this->setTemplate('dashboard/apply/started');
        $this->display();
    }
}