<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Dashboard;

use Db;
use Proxim\Database\DbQuery;
use Proxim\Controller;
use Proxim\Pager;
use Proxim\Currency;
use Proxim\Site\Site;
use Proxim\Configuration;
use Proxim\Order\Order;
use Proxim\User\Employee;
use Proxim\Validate;
use Proxim\Tools;
use Proxim\Util\DateUtils;
use Proxim\Util\ArrayUtils;

class Notifications extends Controller {
    public function getNotifications() {
        $app = $this->app;
        $user = $app->user;
        $params = $app->request->get();
        $smarty = $app->smarty;

        $this->setVars([
            'page_title' => "Notifications"
        ]);

        $notifications = $user->getNotifications();

        $smarty->assign([
            'view' => 'notifications',
            'sub_view' => '',
            'notifications' => $notifications
        ]);

        $this->setTemplate('dashboard/notifications');
        $this->display(); 
    }
}