<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Dashboard;

use Db;
use Proxim\Controller;
use Proxim\Database\DbQuery;
use Proxim\Pager;
use Proxim\Currency;
use Proxim\Coupon;
use Proxim\Site\Site;
use Proxim\Configuration;
use Proxim\Module\Module;
use Proxim\Order\Order;
use Proxim\User\Customer;
use Proxim\User\Employee;
use Proxim\Validate;
use Proxim\Tools;
use Proxim\Util\DateUtils;
use Proxim\Util\ArrayUtils;

class Coupons extends Controller {
    public function coupons( $sub_view = "coupons", $coupon_id = null ) {
        $app = $this->app;
        $params = $app->request->get();
        $user = $app->user;
        $smarty = $app->smarty;

        if(!$user->is_admin) {
            $this->setTemplate('404');
            $this->display();
        }

        $this->setVars([
            'page_title' => "Coupons"
        ]);

        switch( $sub_view ) {
            case 'coupons':
                $selected_page = ArrayUtils::has($params, 'page') ? (int) ArrayUtils::get($params, 'page') : 1;
                $coupons = array();

                $result = Coupon::getCoupons( false, false );
                $total_coupons = count($result);

                if( $total_coupons > 0) {
                    $params['total_items'] = $total_coupons;
                    $params['selected_page'] = $selected_page;
                    $params['items_per_page'] = Configuration::get('MAX_RESULTS', null, 10)*2;
                    $params['url'] = '/coupons?page=%s';

                    $pager = new Pager( $params );
                    $limit_query = $pager->getLimitSql();

                    $sql = new DbQuery();
                    $sql->select('c.*');
                    $sql->from('coupon', 'c');
                    $sql->orderBy('c.coupon_id DESC');
                    $sql .= $limit_query;

                    $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql);

                    foreach ( $result as $coupon ) {
                        $coupon = new Coupon( (int) $coupon['coupon_id'] );
                        if(Validate::isLoadedObject($coupon)) {
                            $coupon = (array) $coupon;
                            $site = new Site( (int) $coupon['site_id'] );
                            $coupon['site_name'] = $site->name;
                            
                            if( $coupon['coupon_type'] == "1" ) {
                                $coupon['coupon_type'] = "Percent";
                                $coupon['coupon_value'] = $coupon['coupon_value']."%"; 
                
                            } elseif( $coupon['coupon_type'] == "3" ) {
                                $coupon['coupon_type'] = "Amount";
                                $coupon['coupon_value'] = "$".$coupon['coupon_value']; 
                
                            } elseif( $coupon['coupon_type'] == "5" ) {
                                $coupon['coupon_type'] = "Free Unit";
                
                                switch( $coupon['service_type_id'] ) {
                                    case '3':
                                        $coupon['coupon_value'] = "Writer Category";
                                        break;
                                    case '21':
                                        $coupon['coupon_value'] = "Used Sources";
                                        break;
                                    case '4':
                                        $coupon['coupon_value'] = "Writer Samples";
                                        break;
                                    case '37':
                                        $coupon['coupon_value'] = "Complex Assignment";
                                        break;
                                    case '41':
                                        $coupon['coupon_value'] = "Expert Proofreading";
                                        break;
                                    case '5':
                                        $coupon['coupon_value'] = "Progressive Delivery";
                                        break;
                                }
                
                            } elseif( $coupon['coupon_type'] == "7" ) {
                                $coupon['coupon_type'] = "Writer Category";
                
                                if( $coupon['writer_category_id'] == "3" ) {
                                    $coupon['coupon_value'] = "ESL";
                                } elseif( $coupon['writer_category_id'] == "4" ) {
                                    $coupon['coupon_value'] = "ENL";
                                }
                            } elseif( $coupon['coupon_type'] == "9" ) {
                                $coupon['coupon_type'] = "Client CPP";
                                $coupon['coupon_value'] = "$".$coupon['coupon_value']; 
                            }

                            $coupons[] = $coupon;
                        } 
                    }

                    $app->smarty->assign([
                        'pager' => $pager->getPager()
                    ]);
                }
        
                $smarty->assign([
                    'total_coupons' => $total_coupons,
                    'coupons' => $coupons,
                ]);
                break;
            
            case 'add':
                $sites = new DbQuery();
                $sites->select('s.*');
                $sites->from('site', 's');
                $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS( $sites );
                
                $smarty->assign([
                    'sites' => $result,
                ]);
                break;
            case 'edit':
                
                $coupon = new Coupon( (int) $coupon_id );
                if(!Validate::isLoadedObject($coupon)) {
                    $this->setTemplate('404');
                    $this->display();
                }

                $sites = new DbQuery();
                $sites->select('s.*');
                $sites->from('site', 's');
                $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS( $sites );
                
                $smarty->assign([
                    'sites' => $result,
                    'coupon' => (array) $coupon,
                ]);

                break;
            default:
                $this->setTemplate('404');
                $this->display();
                break;
        }

        $smarty->assign([
            'view' => 'coupons',
            'sub_view' => $sub_view
        ]);

        $this->setTemplate('dashboard/coupons');
        $this->display();
    }
}