<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Api;

use Db;
use Proxim\Configuration;
use Proxim\Controller;
use Proxim\Database\DbQuery;
use Proxim\Hook;
use Proxim\Mail;
use Proxim\MailTemplate;
use Proxim\Preference\WritingGuide;
use Proxim\Site\Site;
use Proxim\User\Customer;
use Proxim\User\Employee;
use Proxim\Util\ArrayUtils;
use Proxim\Util\DateUtils;
use Proxim\Validate;

class Info extends Controller {
    public function guide( $sub_view, $action ) {
        $app = $this->app;
        $payload = $app->request->post();
        $user = $app->user;
 
        switch($sub_view) {
            case 'writing-guide':
            case 'payment-guide':
            case 'faqs':
                if($action == 'add' || $action == 'edit') {
                    $insert = true;
                    if(ArrayUtils::has($payload, 'guide_id')) {
                        $guideId = ArrayUtils::get($payload, 'guide_id');
                        $writingGuide = new WritingGuide( (int) $guideId  );
                        if(!Validate::isLoadedObject($writingGuide)) {
                            return $this->response([
                                "error" => true,
                                "message" => "resource does not exist"
                            ]);
                        }
                        $insert = false;
                    } else {
                        $writingGuide = new WritingGuide();

                        if($sub_view == 'writing-guide') {
                            $writingGuide->type = WritingGuide::TYPE_WRITING;
                        } elseif($sub_view == 'payment-guide') {
                            $writingGuide->type = WritingGuide::TYPE_PAYMENT;
                        } elseif($sub_view == 'faqs') {
                            $writingGuide->type = WritingGuide::TYPE_FAQ;
                        }
                    }

                    $title = ArrayUtils::get($payload, 'title');
                    $guide = ArrayUtils::get($payload, 'guide');

                    if(!$title) {
                        if($sub_view == 'faqs') {
                            return $this->response([
                                "error" => true,
                                "message" => "Please enter the question"
                            ]);
                        } else {
                            return $this->response([
                                "error" => true,
                                "message" => "Please enter the title"
                            ]);
                        }
                    }

                    if(!$guide) {
                        if($sub_view == 'faqs') {
                            return $this->response([
                                "error" => true,
                                "message" => "Please enter the answer"
                            ]);
                        } else {
                            return $this->response([
                                "error" => true,
                                "message" => "Please enter the guide"
                            ]);
                        }
                    }

                    $writingGuide->title = $title;
                    $writingGuide->guide = $guide;

                    if($insert) {
                        $writingGuide->add();

                        return $this->response([
                            'callback' => 'window.location.href="/info/'.$sub_view.'/edit/'.$writingGuide->id.'";'
                        ]);
                        break;
                    } else {
                        $writingGuide->update();

                        return $this->response([
                            "success" => true,
                            "message" => "Changes have been updated successfully"
                        ]);
                    }
                }
                break;

            case 'software-programming':
                if($action == 'add' || $action == 'edit') {
                    $insert = true;
                    if(ArrayUtils::has($payload, 'item_id')) {
                        $item_id = ArrayUtils::get($payload, 'item_id');
                        $result = Db::getInstance()->getValue('SELECT software_programming_id FROM ' . Db::prefix('software_programming') . ' WHERE software_programming_id = ' . (int) $item_id);
                        if(!$result) {
                            return $this->response([
                                "error" => true,
                                "message" => "resource does not exist"
                            ]);
                        }
                        $insert = false;
                    }

                    $title = ArrayUtils::get($payload, 'title');

                    if(!$title) {
                        return $this->response([
                            "error" => true,
                            "message" => "Please enter the title"
                        ]);
                    }

                    if($insert) {
                        $result = Db::getInstance()->insert('software_programming', [
                            'title' => pSQL($title),
                            'date_add' => DateUtils::now()
                        ]);

                        return $this->modal('SUCCESS', "Added successfully", "Item added successfully");	
                        break;
                    } else {
                        $result = Db::getInstance()->update('software_programming', [
                            'title' => pSQL($title),
                            'date_upd' => DateUtils::now()
                        ], 'software_programming_id = '. (int) $item_id );

                        return $this->response([
                            "success" => true,
                            "message" => "Changes have been updated successfully"
                        ]);
                    }
                }
                break;

            default:
                return $this->response([
                    "error" => true,
                    "message" => "Error 404. Resource not found"
                ]);
                break;
            
        }
    }
}