<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Util;

use Doctrine\Inflector\Inflector as DoctrineInflector;
use Doctrine\Inflector\InflectorFactory;

/**
 * Utility class to get an Inflector as singleton
 */
class Inflector
{
    private static $inflector;

    public static function getInflector(): DoctrineInflector
    {
        if (null === self::$inflector) {
            self::$inflector = InflectorFactory::create()->build();
        }

        return self::$inflector;
    }
}