<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\User;

use Proxim\ObjectModel;

/**
 * EmployeePool
 */
class EmployeePool extends ObjectModel
{
	/** @var $id EmployeePool ID */
	public $id;

	/** @var string name */
	public $name;
	
	/** @var string description */
	public $description;

    /** @var string color */
	public $color;

    /** @var string badge */
	public $badge;

	/** @var string requirements */
	public $requirements;

	/** @var string benefits */
	public $benefits;

    /** @var string status */
	public $status = 'active';

    /** @var string source */
	public $source;

    /** @var int rating */
	public $rating = 0;

	/** @var int order */
	public $order = 0;

    /** @var bool urgent_orders */
	public $urgent_orders = 0;

    /** @var bool new_customers */
	public $new_customers = 0;

    /** @var bool auto_delivery */
	public $auto_delivery = 0;

    /** @var float base_price */
	public $base_price = 0;

	/** @var float price_per_page */
	public $price_per_page = 0;

	/** @var float price_per_word */
	public $price_per_word = 0;
	
	/** @var int academic_level */
	public $academic_level;

	/** @var int writer_category */
	public $writer_category;

    /** @var int takes */
	public $takes = 0;

    /** @var int bids */
	public $bids = 0;
	
	/** @var bool is_default */
	public $is_default = 0;
	
	/** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;

	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'employee_pool',
        'primary' => 'employee_pool_id',
        'fields' => array(
			'name' => array('type' => self::TYPE_STRING, 'size' => 255),
			'description' => array('type' => self::TYPE_STRING),
			'color' => array('type' => self::TYPE_STRING, 'size' => 64),
			'badge' => array('type' => self::TYPE_STRING),
			'requirements' => array('type' => self::TYPE_STRING),
			'benefits' => array('type' => self::TYPE_STRING),
			'status' => array('type' => self::TYPE_STRING, 'size' => 64),
			'rating' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
			'order' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'urgent_orders' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'new_customers' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'auto_delivery' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'base_price' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'price_per_page' => array('type' => self::TYPE_FLOAT, 'validate' => 'isPrice'),
            'price_per_word' => array('type' => self::TYPE_FLOAT, 'validate' => 'isPrice'),
			'academic_level' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
			'writer_category' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
			'takes' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
			'bids' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'is_default' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
			'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
		)
	);

	/**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null)
    {
		parent::__construct($id);
	}
}
