<?php 
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2020 Proxim
 * @version    1.0
 * @since      File available since Release 1.0
*/

namespace Proxim\Presenter\Order;

use Exception;
use Proxim\Order\File as OrderFile;
use Proxim\Presenter\PresenterInterface;

class OrderFilePresenter implements PresenterInterface
{
    /**
     * @param OrderFile $orderFile
     *
     * @return OrderFilePresenter
     *
     * @throws Exception
     */
    public function present($orderFile)
    {
        if (!($orderFile instanceof OrderFile)) {
            throw new Exception('OrderFilePresenter can only present instance of OrderFile');
        }

        return new OrderFileLazyArray($orderFile);
    }
}