<?php 
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2020 Proxim
 * @version    1.0
 * @since      File available since Release 1.0
*/

namespace Proxim\Presenter\Deadline;

use Exception;
use Proxim\Preference\Deadline;
use Proxim\Presenter\PresenterInterface;

class DeadlinePresenter implements PresenterInterface
{
    /**
     * @param Deadline $deadline
     *
     * @return DeadlineLazyArray
     *
     * @throws Exception
     */
    public function present($deadline)
    {
        if (!($deadline instanceof Deadline)) {
            throw new Exception('DeadlinePresenter can only present instance of Deadline');
        }

        return new DeadlineLazyArray($deadline);
    }
}