<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Preference;

use Db;
use Proxim\Database\DbQuery;
use Proxim\ObjectModel;

/**
 * PaperFormat
 */
class PaperFormat extends ObjectModel
{
	/** @var $id PaperFormat ID */
    public $id;

    /** @var string title */
    public $title;

    /** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;
	
	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'paper_format',
        'primary' => 'paper_format_id',
        'fields' => array( 
            'title' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true, 'size' => 255),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        ),
    );

    /**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null) {
		parent::__construct($id);
    }
    
    /**
     * Return paper formats by site ID.
     *
     * @return array PaperFormats
     */
    public static function getPaperFormats()
    {
        $sql = new DbQuery();
        $sql->select('pf.*');
        $sql->from('paper_format', 'pf');
        $sql->orderBy('pf.title ASC');

        $result = Db::getInstance()->executeS($sql);
        
        return $result;
    }
}