<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Preference;

use Proxim\ObjectModel;

/**
 * ItemPricing
 */
class ItemPricing extends ObjectModel
{
	/** @var $id ItemPricing ID */
    public $id;

    /** @var int discipline_id */
    public $discipline_id;

    /** @var int task_size_id */
    public $task_size_id;

    /** @var int price */
    public $price;

    /** @var int is_calculations */
    public $is_calculations = 0;

    /** @var int is_programming */
    public $is_programming = 0;
    
    /** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;
	
	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'item_pricing', 
        'primary' => 'item_pricing_id',
        'fields' => array( 
            'discipline_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required'=> true),
            'task_size_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required'=> true),
            'price' => array('type' => self::TYPE_FLOAT, 'validate' => 'isPrice', 'required'=> true),
            'is_calculations' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'is_programming' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        ),
    );

    /**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null) {
		parent::__construct($id);
    }
}