<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Preference;

use Db;
use Proxim\Database\DbQuery;
use Proxim\Cache\Cache;
use Proxim\ObjectModel;
use Proxim\Util\ArrayUtils;
use Proxim\Util\DateUtils;
use Proxim\Validate;
use Proxim\Tools;

/**
 * Descriptor
 */
class Descriptor extends ObjectModel
{
	/** @var $id Descriptor ID */
    public $id;

    /** @var int discipline_id */
    public $discipline_id;

    /** @var int task_size_id */
    public $task_size_id;

    /** @var string example */
    public $example;

    /** @var int is_calculations */
    public $is_calculations = 0;

    /** @var int is_programming */
    public $is_programming = 0;
    
    /** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;
	
	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'descriptor',  
        'primary' => 'descriptor_id', 
        'fields' => array( 
            'discipline_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required'=> true),
            'task_size_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required'=> true),
            'example' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true),
            'is_calculations' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'is_programming' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        ),
    );

    /**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null) {
		parent::__construct($id);
    }

    public function getDeliverables() {
        $query = new DbQuery();
        $query->select('d.deliverable_id, d.name, d.slug');
        $query->leftJoin('deliverable', 'd', 'dd.deliverable_id = d.deliverable_id');
        $query->from('descriptor_deliverable', 'dd');
        $query->where('dd.descriptor_id = ' . (int) $this->id );
        $deliverables = Db::getInstance()->executeS($query);

        $deliverablesByIds = array();
        foreach($deliverables as $deliverable) {
            $deliverablesByIds[$deliverable['deliverable_id']] = $deliverable;
        }
 
        return $deliverablesByIds;
    }
}