<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Preference;

use Db;
use Proxim\Database\DbQuery;
use Proxim\Cache\Cache;
use Proxim\ObjectModel;
use Proxim\Util\ArrayUtils;
use Proxim\Util\DateUtils;
use Proxim\Validate;
use Proxim\Tools;

/**
 * Deliverable
 */
class Deliverable extends ObjectModel
{
	/** @var $id Deliverable ID */
    public $id;

    /** @var string name */
    public $name;

     /** @var string slug */
     public $slug;
    
    /** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;
	
	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'deliverable',
        'primary' => 'deliverable_id',
        'fields' => array( 
            'name' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true, 'size' => 255),
            'slug' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true, 'size' => 255),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        ),
    );

    /**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null) {
		parent::__construct($id);
    }

    /**
     * Return deliverables 
     *
     * @return array Deliverable
     */
    public static function getDeliverables()
    {
        $sql = self::getDeliverablesQuery();
        $sql->orderBy('d.name ASC');
        $result = Db::getInstance()->executeS($sql);
        return $result;
    }

    /**
     * Get Deliverables query.
     *
     * @return DbQuery
     */
    public static function getDeliverablesQuery()
    {
        $query = new DbQuery();
        $query->select('d.*');
        $query->from('deliverable', 'd');

        return $query;
    }
}