<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Preference\ArticleWriting;

use Proxim\ObjectModel;

/**
 * TargetAudience
 */
class TargetAudience extends ObjectModel
{
	/** @var $id TargetAudience ID */
    public $id;

    /** @var string title */
    public $title;
    
    /** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;
	
	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'target_audience',
        'primary' => 'target_audience_id', 
        'fields' => array( 
            'title' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        ),
    );

    /**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null) {
		parent::__construct($id);
    }
}