<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Preference;

use Db;
use Proxim\Database\DbQuery;
use Proxim\ObjectModel;

/**
 * AcademicLevel
 */
class AcademicLevel extends ObjectModel
{
	/** @var $id AcademicLevel ID */
    public $id;

    /** @var string title */
    public $title; 

    /** @var string short_title */
    public $short_title;

    /** @var string degree */
    public $degree;

    /** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;
	
	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'academic_level',
        'primary' => 'academic_level_id',
        'fields' => array( 
            'title' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true, 'size' => 255),
            'short_title' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'size' => 255),
            'degree' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'size' => 255),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        ),
    );

    /**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null) {
		parent::__construct($id);
    }
    
    /**
     * Return academic levels.
     *
     * @return array AcademicLevels
     */
    public static function getAcademicLevels($siteId = null)
    {
        $sql = new DbQuery();
        $sql->select('al.*');
        $sql->from('academic_level', 'al');
        if($siteId) {
            $sql->innerJoin('academic_level_site', 'als', 'als.`academic_level_id` = al.`academic_level_id` AND als.site_id = ' . (int) $siteId);
        }
        $sql->orderBy('al.academic_level_id ASC');
        $result = Db::getInstance()->executeS($sql);

        // get default academic levels
        if($siteId && !count($result)) {
            $sql = new DbQuery();
            $sql->select('al.*');
            $sql->from('academic_level', 'al');
            $sql->orderBy('al.academic_level_id ASC');
            $result = Db::getInstance()->executeS($sql);
        }

        $academic_levels = array();
        foreach($result as $academic_level) {
            $academic_level['id'] = (int) $academic_level['academic_level_id'];
            $academic_levels[] = $academic_level;
        }
        
        return $academic_levels;
    }
}