<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Order;

use Db;
use Proxim\Database\DbQuery;
use Proxim\Cache\Cache;
use Proxim\Application;
use Proxim\ObjectModel;
use Proxim\User\Customer;
use Proxim\Util\ArrayUtils;
use Proxim\Util\DateUtils;
use Proxim\Validate;
use Proxim\Tools;
use Proxim\User\Employee;

/**
 * Message
 */
class Message extends ObjectModel
{
	/** @var $id Message ID */
	public $id;

	/** @var int order_id */
	public $order_id;

	/** @var int sender_id */
	public $sender_id;

	/** @var int parent_id */
	public $parent_id;
	
	/** @var int from_department */
	public $from_department;
	
	/** @var int to_department */
	public $to_department;
	
	/** @var string subject */
	public $subject;
	
	/** @var string body */
	public $body;
	
	/** @var bool is_deleted */
	public $is_deleted = 0;

	/** @var string deleted_at */
	public $deleted_at;
	
	/** @var bool is_viewed */
	public $is_viewed = 0;
	
	/** @var string viewed_at */
	public $viewed_at;
    
    /** @var bool is_verified */
	public $is_verified = 1;

	/** @var string verified_at */
	public $verified_at;
	
	/** @var string date_add */
	public $date_add;
	
	/** @var string date_upd */
    public $date_upd;

	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'order_message',
        'primary' => 'message_id',
        'fields' => array( 
			'order_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
			'sender_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
			'parent_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
			'from_department' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
			'to_department' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
			'subject' => array('type' => self::TYPE_STRING),
			'body' => array('type' => self::TYPE_HTML),
			'is_deleted' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'is_viewed' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
			'is_verified' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
			'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
		)
	);

	/**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null)
    {
        parent::__construct($id);
	}
}