<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Order;

use Proxim\ObjectModel;

/**
 * DeliverySchedule
 */
class DeliverySchedule extends ObjectModel
{
    /** @var $id DeliverySchedule ID */
    public $id;
    
    /** @var int order_id */
    public $order_id;

    /** @var int pages */
    public $pages = 0;

    /** @var int slides */
    public $slides = 0;

    /** @var int charts */
    public $charts = 0;

    /** @var string comment */
    public $comment;

    /** @var string customer_deadline */
    public $customer_deadline;

    /** @var string writer_deadline */
    public $writer_deadline;

    /** @var int date_upd */
    public $date_upd;

    /** @var string date_add */
    public $date_add;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'order_pd_schedule',
        'primary' => 'schedule_id',
        'fields' => array(
			'order_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
            'pages' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'slides' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'charts' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'comment' => array('type' => self::TYPE_STRING),
            'customer_deadline' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'writer_deadline' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
			'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
		)
	);

    /**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null)
    {
        parent::__construct($id);
    }
}