<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Assets;

use Proxim\Application;

/**
 * AssetUrlGeneratorTrait
 */
trait AssetUrlGeneratorTrait
{
    /**
     * @var string
     */
    protected $fqdn;

    /**
     * @param string $fullPath
     *
     * @return string
     */
    protected function getUriFromPath($fullPath)
    {
        return str_replace(PROX_DIR_ROOT, rtrim(Application::getInstance()->base_uri, '/'), $fullPath);
    }

    /**
     * @param string $fullUri
     *
     * @return string
     */
    protected function getPathFromUri($fullUri)
    {
        if ('' !== ($trimmedUri = rtrim(Application::getInstance()->base_uri, '/'))) {
            return PROX_DIR_ROOT . str_replace($trimmedUri, '', $fullUri);
        }

        return PROX_DIR_ROOT . $fullUri;
    }

    /**
     * @return string
     */
    protected function getFQDN()
    {
        if (is_null($this->fqdn)) {
            $this->fqdn = Application::getInstance()->base_uri;
        }

        return $this->fqdn;
    }
}
