<?php 
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Assets;

/**
 * AbstractAssetManager
 */
abstract class AbstractAssetManager
{
    protected $directories;

    protected $list = array();

    const DEFAULT_MEDIA = 'all';
    const DEFAULT_PRIORITY = 50;
    const DEFAULT_JS_POSITION = 'bottom';

    use \Proxim\Assets\AssetUrlGeneratorTrait;

    public function __construct(array $directories)
    {
        $this->directories = $directories;
        $this->list = $this->getDefaultList();
    }

    abstract protected function getDefaultList();

    abstract protected function getList();

    protected function getFullPath($relativePath)
    {
        foreach ($this->getDirectories() as $baseDir) {
            $fullPath = $baseDir . ltrim($relativePath, '/'); // not DIRECTORY_SEPARATOR because, it's path included manualy
            if (file_exists($this->getPathFromUri($fullPath))) {
                return $fullPath;
            }
        }

        return false;
    }

    private function getDirectories()
    {
        static $directories;

        if (null === $directories) {
            foreach ($this->directories as $baseDir) {
                if (!empty($baseDir)) {
                    $directories[] = $baseDir;
                }
            }
        }

        return $directories;
    }

}