<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Addon\Theme;

use Symfony\Contracts\Translation\TranslatorInterface;

class ThemeValidator
{
    private $errors = [];

    public function getErrors($themeName)
    {
        return array_key_exists($themeName, $this->errors) ? $this->errors[$themeName] : false;
    }

    public function isValid(Theme $theme)
    {
        return $this->hasRequiredFiles($theme)
            && $this->hasRequiredProperties($theme);
    }

    private function hasRequiredProperties(Theme $theme)
    {
        $themeName = $theme->getName();

        foreach ($this->getRequiredProperties() as $prop) {
            if (!$theme->has($prop)) {
                if (!array_key_exists($themeName, $this->errors)) {
                    $this->errors[$themeName] = [];
                }

                $this->errors[$themeName] = sprintf(
                    'An error occurred. The information "%s" is missing.',
                    $prop
                );
            }
        }

        return !array_key_exists($themeName, $this->errors);
    }

    public function getRequiredProperties()
    {
        return [
            'name',
            'display_name',
            'version',
            'license_key',
            'author.name'
        ];
    }

    private function hasRequiredFiles(Theme $theme)
    {
        $themeName = $theme->getName();

        foreach ($this->getRequiredFiles() as $file) {
            $childFile = $theme->getDirectory() . $file;
            if (!file_exists($childFile)) {
                if (!array_key_exists($themeName, $this->errors)) {
                    $this->errors[$themeName] = [];
                }

                $this->errors[$themeName] = sprintf('An error occurred. The template "%s" is missing.', $file);
            }
        }

        return !array_key_exists($themeName, $this->errors);
    }

    public function getRequiredFiles()
    {
        return [
            'preview.png',
            'config/theme.yml'
        ];
    }
}