<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Addon\Theme;

use Db;
use Proxim\Application;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Finder\Finder;

class ThemeManagerBuilder
{
    private $app;
    private $db;
    private $themeValidator;

    public function __construct(Application $app, Db $db, ThemeValidator $themeValidator = null)
    {
        $this->app = $app;
        $this->db = $db;
        $this->themeValidator = $themeValidator;
    }

    public function build()
    {
        if (null === $this->themeValidator) {
            $this->themeValidator = new ThemeValidator();
        }

        return new ThemeManager(
            $this->app,
            $this->themeValidator,
            new Filesystem(),
            new Finder(),
            $this->buildRepository($this->app)
        );
    }

    public function buildRepository(Application $app = null)
    {
        return new ThemeRepository(
            new Filesystem(),
            $app
        );
    }
}