<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Adapter;

use Symfony\Component\HttpKernel\KernelInterface;

/**
 * Class SymfonyContainer.
 *
 * This is a TEMPORARY class for quick access to the Symfony Container
 */
final class SymfonyContainer
{
    /** @var self */
    private static $instance = null;

    /**
     * Get a singleton instance of SymfonyContainer.
     *
     * @return \Symfony\Component\DependencyInjection\ContainerInterface;
     */
    public static function getInstance()
    {
        if (!isset(self::$instance)) {
            global $kernel;

            if (null !== $kernel && $kernel instanceof KernelInterface) {
                self::$instance = $kernel->getContainer();
            }
        }

        return self::$instance;
    }

    public static function resetStaticCache()
    {
        self::$instance = null;
    }
}