<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Adapter;

use Db;
use Proxim\Database\DbQuery;
use Proxim\Cache\Cache;


class EntityMapper
{
    /**
     * Load ObjectModel.
     *
     * @param $id
     * @param $entity \ObjectModel
     * @param $entity_defs
     * @param $should_cache_objects
     *
     * @throws \ProximDatabaseException
     */
    public function load($id, $entity, $entity_defs, $should_cache_objects)
    {
        // Load object from database if object id is present
        $cache_id = 'objectmodel_' . $entity_defs['classname'] . '_' . $id;
        if (!$should_cache_objects || !Cache::isStored($cache_id)) {
            $sql = new DbQuery();
            $sql->from($entity_defs['table'], 'a');
            $sql->where('a.`' . bqSQL($entity_defs['primary']) . '` =  \'' . pSQL($id) . '\'');

            if ($object_datas = Db::getInstance()->getRow($sql)) {
                $entity->id = $id;
                foreach ($object_datas as $key => $value) {
                    if (property_exists($entity, $key) || isset($entity_defs['fields'][$key])) {
                        $entity->{$key} = $value;
                    } else {
                        unset($object_datas[$key]);
                    }
                }
                if ($should_cache_objects) {
                    Cache::store($cache_id, $object_datas);
                }
            }
        } else {
            $object_datas = Cache::retrieve($cache_id);
            if ($object_datas) {
                $entity->id = $id;
                foreach ($object_datas as $key => $value) {
                    if (property_exists($entity, $key)) {
                        $entity->{$key} = $value;
                    }
                }
            }
        }
    }
}
