<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.0.0
 * @since      File available since Release 1.0.0
 */

// Short name
define('PROX_DS', DIRECTORY_SEPARATOR);
define('PROX_NAMESPACE',          'Proxim');
define('PROX_DIR',                   dirname(__FILE__));
define('PROX_DIR_ROOT',              rtrim(PROX_DIR, PROX_DS) . PROX_DS);
define('PROX_DIR_INCLUDES',           PROX_DIR_ROOT . 'prox-includes' . PROX_DS);
define('PROX_DIR_CLASSES',            PROX_DIR_INCLUDES . 'classes' . PROX_DS);
define('PROX_DIR_CONTENT',            PROX_DIR_ROOT . 'content' . PROX_DS);
define('PROX_DIR_CACHE',              PROX_DIR_CONTENT . 'cache' . PROX_DS);
define('PROX_DIR_THEMES',          PROX_DIR_CONTENT . 'themes' . PROX_DS);
define('PROX_DIR_CONTROLLERS',        PROX_DIR_INCLUDES . 'controllers' . PROX_DS);

/**#@+
 * Authentication Unique Keys and Salts.
 */
define( 'PROX_COOKIE_KEY', 'hcmy3vvdmgj1droykuyodzzz0f2kmisj9fjls8q4wonyx4hfiepgvefbsjlflw1c' );
define( 'PROX_COOKIE_IV', 'h2HHwDjqA2dJuU' );

// enviroment settings
error_reporting(E_ALL ^ (E_NOTICE | E_WARNING));

if (!defined('PROX_MAGIC_QUOTES_GPC')) {
    define('PROX_MAGIC_QUOTES_GPC', false);
}

if ( file_exists(PROX_DIR . PROX_DS . 'vendor' . PROX_DS . 'autoload.php') ) {
    require_once PROX_DIR . PROX_DS . 'vendor' . PROX_DS . 'autoload.php';
}

require_once PROX_DIR_ROOT . 'autoload.php';
require_once PROX_DIR_INCLUDES . 'functions.php';
require_once PROX_DIR_INCLUDES . 'globals.php';

// check the config file
if(file_exists(PROX_DIR_ROOT . 'config.php')) {
    /* the config file exist -> start the system */
    header('Location: /');
}

use Proxim\Application;
use Proxim\Configuration;
use Proxim\Tools;
use Proxim\Validate;
use Proxim\User\Employee;
use Proxim\Util\DateUtils;
use Proxim\Util\ArrayUtils;
use Proxim\Crypto\Hashing;
use Proxim\Database\DbCore;
use Proxim\Database\DbMySQLiCore;
use Proxim\Database\DbPDOCore;
use Proxim\Preference\Discipline;
use Proxim\Preference\PaperFormat;
use Proxim\Preference\PaperType;
use Proxim\Preference\UploadType;

abstract class Db extends DbCore {};
class DbPDO extends DbPDOCore {};
class DbMySQLi extends DbMySQLiCore {};

$app = new Application([
    'mode' => PROX_ENVIRONMENT,
    'debug' => PROX_DEBUG
]);

$payload = Tools::getAllValues();

if(ArrayUtils::has($payload, 'submit')) {
    $db_server = ArrayUtils::get($payload, 'db_host');
    $db_user = ArrayUtils::get($payload, 'db_username');
    $db_password = ArrayUtils::get($payload, 'db_password');
    $database = ArrayUtils::get($payload, 'db_name');

    $db_class = Db::getClass();
    $db = new $db_class(
        $db_server,
        $db_user,
        $db_password,
        $database
    );
    
    if(!$db) {
        die("DB_ERROR");
    }
    
    if(!defined('DB_NAME')) define( 'DB_NAME', $database );
    if(!defined('DB_USER')) define( 'DB_USER', $db_user );
    if(!defined('DB_PASSWORD')) define( 'DB_PASSWORD', $db_password );
    if(!defined('DB_SERVER')) define( 'DB_SERVER', $db_server );
    if(!defined('DB_PREFIX')) define( 'DB_PREFIX', 'prox_' );

    // [2] check admin data
    $first_name = ArrayUtils::get($payload, 'admin_first_name');
    if ( $first_name && !Validate::isName($first_name) ) {
        die("Enter a valid first name");
    }
    if ( Tools::strlen($first_name) > 20 ) {
        die("Your first name must be less than 20 characters long. Please try another");
    }
    if ( Tools::strlen($first_name) < 3 ) {
        die("Your first name must be at least 3 characters long. Please try another");
    }

    $last_name = ArrayUtils::get($payload, 'admin_last_name');
    if ( $last_name && !Validate::isName($last_name) ) {
        die("Enter a valid last name");
    }

    if ( Tools::strlen($last_name) > 20 ) {
        die("Your last name must be less than 20 characters long. Please try another");
    }
    if ( Tools::strlen($last_name) < 3 ) {
        die("Your last name must be at least 3 characters long. Please try another");
    }

    $email = ArrayUtils::get($payload, 'admin_email');
    if ( !$email || !Validate::isEmail($email) ) {
        die("Enter a valid email address");
    }

    $password = ArrayUtils::get($payload, 'admin_password');
    if ( !$password || !Validate::isPasswd($password) ) {
        die("Password must be long than 6 characters");
    }

    $date = DateUtils::now();

    // [3] create the database
    $structure = "
        DROP TABLE IF EXISTS `prox_customer`;

        CREATE TABLE IF NOT EXISTS `prox_customer` (
            `customer_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `google_analytics_id` VARCHAR(255) NOT NULL UNIQUE,
            `email` VARCHAR(255) NOT NULL,
            `name` VARCHAR(255) DEFAULT NULL,
            `phone` VARCHAR(50) DEFAULT NULL,
            `country_id` BIGINT(20) unsigned NOT NULL,
            `site_id` BIGINT(20) unsigned NOT NULL,
            `password` VARCHAR(255) NOT NULL,
            `new_password` VARCHAR(255) DEFAULT NULL,
            `reset_password_token` VARCHAR(255) DEFAULT NULL,
            `reset_password_validity` DATETIME DEFAULT NULL,
            `last_passwd_gen` DATETIME DEFAULT NULL,
            `secure_key` VARCHAR(255) NOT NULL DEFAULT '-1',
            `policy_accepted` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `policy_accepted_at` DATETIME DEFAULT NULL,
            `total_spent` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `referrer_id` BIGINT(20) unsigned DEFAULT NULL,
            `affiliate_used` TINYINT(1) unsigned NOT NULL default '0',
            `affiliate_balance` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `last_academic_level` BIGINT(20) unsigned  DEFAULT NULL,
            `last_payment_method` BIGINT(20) unsigned  DEFAULT NULL,
            `is_subscribed` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `is_test` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `is_banned` TINYINT(1) unsigned NOT NULL default '0',
            `push_notifications` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `last_login` DATETIME DEFAULT NULL,
            `last_activity` DATETIME DEFAULT NULL,
            `reg_date` DATETIME DEFAULT NULL,
        PRIMARY KEY(`customer_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_employee`;

        CREATE TABLE IF NOT EXISTS `prox_employee` (
            `employee_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `employee_group` BIGINT(20) unsigned NOT NULL,
            `email` VARCHAR(255) NOT NULL,
            `first_name` VARCHAR(255) DEFAULT NULL,
            `middle_name` VARCHAR(255) DEFAULT NULL,
            `last_name` VARCHAR(255) DEFAULT NULL,
            `gender` enum('male', 'female') NOT NULL default 'male',
            `phone` VARCHAR(50) DEFAULT NULL,
            `writer_category` INT(10) NOT NULL DEFAULT 0,
            `academic_level` INT(10) NOT NULL DEFAULT 0,
            `employee_rating` INT(10) NOT NULL DEFAULT 0,
            `employee_status` INT(10) NOT NULL DEFAULT 0,
            `avatar` VARCHAR(255) DEFAULT NULL,
            `about` LONGTEXT DEFAULT NULL,
            `facebook_profile` VARCHAR(255) DEFAULT NULL,
            `linkedin_profile` VARCHAR(255) DEFAULT NULL,
            `payment_method` BIGINT(20) unsigned DEFAULT NULL,
            `payment_method_value` VARCHAR(255) DEFAULT NULL,
            `last_pay` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `total_paid` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `total_orders_revised` INT(10) NOT NULL DEFAULT '0',
            `total_orders_rejected` INT(10) NOT NULL DEFAULT '0',
            `email_notifications` TINYINT(1) unsigned NOT NULL default '1',
            `password` VARCHAR(255) NOT NULL,
            `reset_password_token` VARCHAR(255) DEFAULT NULL,
            `reset_password_validity` DATETIME DEFAULT NULL,
            `last_passwd_gen` DATETIME DEFAULT NULL,
            `secure_key` VARCHAR(255) NOT NULL DEFAULT '-1',
            `policy_accepted` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `policy_accepted_at` DATETIME DEFAULT NULL,
            `is_started` TINYINT(1) unsigned NOT NULL default '0',
            `is_banned` TINYINT(1) unsigned NOT NULL default '0',
            `push_notifications` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `live_notifications_counter` INT(10) unsigned NOT NULL DEFAULT '0',
            `live_notifications_lastid` BIGINT(20) UNSIGNED DEFAULT NULL,
            `live_messages_counter` INT(10) unsigned NOT NULL DEFAULT '0',
            `live_messages_lastid` BIGINT(20) UNSIGNED DEFAULT NULL,
            `number_of_takes` INT(10) UNSIGNED DEFAULT '0',
            `timezone` VARCHAR(255) DEFAULT NULL,
            `notification_sound` TINYINT(1) NOT NULL DEFAULT '0',
            `cpp_type` enum('system', 'custom') NOT NULL default 'system',
            `cpp_amount` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `last_login` DATETIME DEFAULT NULL,
            `last_activity` DATETIME DEFAULT NULL,
            `reg_date` DATETIME DEFAULT NULL,
        PRIMARY KEY(`employee_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_order`;

        CREATE TABLE IF NOT EXISTS `prox_order` (
            `order_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `site_id` BIGINT(20) unsigned NOT NULL,
            `order_type` ENUM('academic', 'article') NOT NULL default 'academic',
            `tracking_id` VARCHAR(255) DEFAULT NULL,
            `form_type_id` BIGINT(20) unsigned NOT NULL,
            `form_type` VARCHAR(255) DEFAULT NULL,
            `payment_method` VARCHAR(255) DEFAULT NULL,
            `currency_id` BIGINT(20) unsigned DEFAULT NULL,
            `currency_to_usd_rate` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `coupon_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `gmt` INT(10) NOT NULL,
            `customer_id` BIGINT(20) unsigned NOT NULL,
            `writer_id` BIGINT(20) unsigned DEFAULT NULL,
            `requested_writer_id` BIGINT(20) unsigned DEFAULT NULL,
            `editor_id` BIGINT(20) unsigned DEFAULT NULL,
            `status_id` BIGINT(20) unsigned DEFAULT '0',
            `parent_id` BIGINT(20) unsigned NOT NULL,
            `service_type` BIGINT(20) unsigned NOT NULL DEFAULT 37,
            `tariff_id` BIGINT(20) unsigned NOT NULL,
            `title` TEXT NOT NULL,
            `academic_level_id` BIGINT(20) unsigned NOT NULL,
            `paper_type_id` BIGINT(20) unsigned NOT NULL,
            `paper_type_option` TEXT DEFAULT NULL,
            `topic_category_id` BIGINT(20) unsigned NOT NULL,
            `topic_category_option` TEXT DEFAULT NULL,
            `is_complex_assignment` INT(10) unsigned NOT NULL DEFAULT '0',
            `paper_format_id` BIGINT(20) unsigned NOT NULL,
            `paper_format_option` TEXT DEFAULT NULL,
            `writer_category_id` INT(10) unsigned NOT NULL DEFAULT '0',
            `writer_percent` INT(10) unsigned NOT NULL DEFAULT '0',
            `pages` INT(10) unsigned NOT NULL DEFAULT '0',
            `charts` INT(10) unsigned NOT NULL DEFAULT '0',
            `slides` INT(10) unsigned NOT NULL DEFAULT '0',
            `sources` INT(10) unsigned NOT NULL DEFAULT '0',
            `excel_sheets` INT(10) UNSIGNED NOT NULL DEFAULT '0',
            `spacing` enum('single', 'double') NOT NULL default 'double',
            `paper_details` LONGTEXT DEFAULT NULL,
            `comments` LONGTEXT DEFAULT NULL,
            `writer_samples` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `used_sources` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `expert_proofreading` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `progressive_delivery` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `vip_support` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `plagiarism_report` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `draft_outline` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `raw_cost` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `total` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `tax` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `discount` INT(10) unsigned NOT NULL DEFAULT 0,
            `discount_type` INT(10) unsigned NOT NULL DEFAULT '0',
            `price_per_page` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `total_paid` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `paid_at` DATETIME DEFAULT NULL,
            `is_paid` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `writer_pay` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `is_writer_paid` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `writer_paid_at` DATETIME DEFAULT NULL,
            `is_writer_confirmed` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `editor_pay` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `is_editor_paid` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `editor_paid_at` DATETIME DEFAULT NULL,
            `is_editor_confirmed` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `hrs_customer` INT(10) unsigned NOT NULL DEFAULT '0',
            `customer_deadline` DATETIME DEFAULT NULL,
            `hrs_writer` INT(10) unsigned NOT NULL DEFAULT '0',
            `writer_deadline` DATETIME DEFAULT NULL,
            `writer_assigned` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `writer_assigned_at` DATETIME DEFAULT NULL,
            `editor_assigned` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `editor_assigned_at` DATETIME DEFAULT NULL,
            `ordermanager_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `ordermanager_assigned` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `ordermanager_assigned_at` DATETIME DEFAULT NULL,
            `ordermanager_pay` FLOAT(14,2) DEFAULT 0.00,
            `is_ordermanager_paid` TINYINT(1) UNSIGNED DEFAULT '0',
            `ordermanager_paid_at` DATETIME DEFAULT NULL,
            `approved_at` DATETIME DEFAULT NULL,
            `completed_at` DATETIME DEFAULT NULL,
            `cancelled_at` DATETIME DEFAULT NULL,
            `delivered_at` DATETIME DEFAULT NULL,
            `finished_at` DATETIME DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`order_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_additional_service`;

        CREATE TABLE IF NOT EXISTS `prox_additional_service` (
            `additional_service_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `order_id` BIGINT(20) unsigned NOT NULL,
            `comment` TEXT DEFAULT NULL,
            `tariff_id` BIGINT(20) unsigned DEFAULT NULL,
            `writer_category_id` BIGINT(20) unsigned DEFAULT NULL,
            `pages` INT(10) unsigned NOT NULL DEFAULT '0',
            `charts` INT(10) unsigned NOT NULL DEFAULT '0',
            `slides` INT(10) unsigned NOT NULL DEFAULT '0',
            `writer_samples` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `used_sources` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `expert_proofreading` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `progressive_delivery` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `total` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `paid_at` DATETIME DEFAULT NULL,
            `is_paid` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`additional_service_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_paypal_payment`;

        CREATE TABLE IF NOT EXISTS `prox_paypal_payment` (
            `payment_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `status_id` INT(10) unsigned NOT NULL DEFAULT '0',
            `node_type` VARCHAR(20) DEFAULT NULL,
            `node_id` BIGINT(20) unsigned NOT NULL,
            `amount` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
            PRIMARY KEY(`payment_id`)
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_payment`;

        CREATE TABLE IF NOT EXISTS `prox_payment` (
            `payment_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `node_id` BIGINT(20) UNSIGNED NOT NULL,
            `node_type` VARCHAR(20) DEFAULT NULL,
            `currency_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `conversion_rate` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `payment_method` VARCHAR(255) DEFAULT NULL,
            `transaction_id` VARCHAR(255) DEFAULT NULL,
            `amount` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`payment_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

        DROP TABLE IF EXISTS `prox_order_bid`;

        CREATE TABLE IF NOT EXISTS `prox_order_bid` (
            `bid_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `order_id` BIGINT(20) unsigned NOT NULL,
            `writer_id` BIGINT(20) unsigned NOT NULL,
            `bid_time` INT(10) unsigned NOT NULL DEFAULT '0',
            `amount` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `is_assigned` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `is_deleted` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`bid_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_order_view`;

        CREATE TABLE IF NOT EXISTS `prox_order_view` (
            `order_id` BIGINT(20) unsigned NOT NULL,
            `user_id` BIGINT(20) unsigned NOT NULL,
            `last_viewed` INT(10) unsigned NOT NULL DEFAULT '0',
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        KEY(`order_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_order_file`;

        CREATE TABLE `prox_order_file` (
            `file_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `order_id` BIGINT(20) unsigned NOT NULL,
            `site_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `uploader_id` BIGINT(20) unsigned NOT NULL,
            `file_type_id` INT(10) NOT NULL,
            `file_description` VARCHAR(255) DEFAULT NULL,
            `name` VARCHAR(255) NOT NULL,
            `size` INT(10) NOT NULL DEFAULT '0',
            `source` TEXT NOT NULL,
            `extension` VARCHAR(20) DEFAULT NULL,
            `is_part` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `is_final_file` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `approved` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `approved_at` DATETIME DEFAULT NULL,
            `downloaded` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `downloaded_at` DATETIME DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`file_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_order_message`;

        CREATE TABLE `prox_order_message` (
            `message_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `order_id` BIGINT(20) unsigned DEFAULT NULL,
            `sender_id` BIGINT(20) unsigned DEFAULT NULL,
            `parent_id` BIGINT(20) unsigned NOT NULL,
            `from_department` BIGINT(20) unsigned NOT NULL,
            `to_department` BIGINT(20) unsigned NOT NULL,
            `subject` TEXT DEFAULT NULL,
            `body` LONGTEXT DEFAULT NULL,
            `is_deleted` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `deleted_at` DATETIME DEFAULT NULL,
            `is_viewed` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `viewed_at` DATETIME DEFAULT NULL,
            `is_verified` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `verified_at` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
        PRIMARY KEY(`message_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_order_revision`;

        CREATE TABLE IF NOT EXISTS `prox_order_revision` (
            `revision_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `order_id` BIGINT(20) unsigned NOT NULL,
            `file_id` BIGINT(20) unsigned NOT NULL,
            `grammar` LONGTEXT DEFAULT NULL,
            `format` LONGTEXT DEFAULT NULL,
            `sources` LONGTEXT DEFAULT NULL,
            `customize_cont` LONGTEXT DEFAULT NULL,
            `other` LONGTEXT DEFAULT NULL,
            `instructions` LONGTEXT DEFAULT NULL,
            `client_deadline` INT(10) NOT NULL,
            `request_diff_writer` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `free_revision` TINYINT(1) unsigned NOT NULL DEFAULT '1',
            `date_add` DATETIME DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            PRIMARY KEY `revision_id` (`revision_id`),
            KEY `order_id` (`order_id`),
            KEY `file_id` (`file_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_order_pd_schedule`;

        CREATE TABLE IF NOT EXISTS `prox_order_pd_schedule` (
            `schedule_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `order_id` BIGINT(20) unsigned NOT NULL,
            `status_id` INT(10) NOT NULL DEFAULT '0',
            `pages` INT(10) NOT NULL DEFAULT '0',
            `slides` INT(10) NOT NULL DEFAULT '0',
            `charts` INT(10) NOT NULL DEFAULT '0',
            `comment` TEXT DEFAULT NULL,
            `writer_pay` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `is_writer_paid` TINYINT(1) unsigned NOT NULL default '0',
            `client_pay` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `is_paid` TINYINT(1) unsigned NOT NULL default '0',
            `client_deadline` DATETIME DEFAULT NULL,
            `writer_deadline` DATETIME DEFAULT NULL,
            `is_completed` TINYINT(1) unsigned NOT NULL default '0',
            `completed_at` DATETIME DEFAULT NULL,
            `is_approved` TINYINT(1) unsigned NOT NULL default '0',
            `approved_at` DATETIME DEFAULT NULL,
            `is_accepted` TINYINT(1) unsigned NOT NULL default '0',
            `accepted_at` DATETIME DEFAULT NULL,
            `is_rejected` TINYINT(1) unsigned NOT NULL default '0',
            `rejected_at` DATETIME DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
            PRIMARY KEY(`schedule_id`),
            KEY `orders` ( `order_id` )
        );

        DROP TABLE IF EXISTS `prox_order_meta`;

        CREATE TABLE IF NOT EXISTS `prox_order_meta` (
            `meta_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `order_id` BIGINT(20) unsigned NOT NULL,
            `name` VARCHAR(255) NOT NULL,
            `value` TEXT DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
            PRIMARY KEY(`meta_id`),
            KEY `order_id` ( `order_id` )
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_order_rating`;

        CREATE TABLE `prox_order_rating` (
            `rating_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `order_id` BIGINT(20) unsigned NOT NULL,
            `paper_rating` INT(10) DEFAULT NULL,
            `service_rating` INT(10) DEFAULT NULL,
            `comment` LONGTEXT DEFAULT NULL,
            `paper_on_time` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`rating_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_coupon`;

        CREATE TABLE IF NOT EXISTS `prox_coupon` (
            `coupon_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `site_id` BIGINT(20) unsigned NOT NULL,
            `coupon_type` INT(10) NOT NULL DEFAULT 1,
            `coupon_code` VARCHAR(255) NOT NULL,
            `order_id` BIGINT(20) unsigned DEFAULT NULL,
            `customer_id` BIGINT(20) unsigned DEFAULT NULL,
            `value` INT(10) NOT NULL DEFAULT 0,
            `lifetime` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `active` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `expiry` DATETIME DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
            PRIMARY KEY `coupon_id` (`coupon_id`),
            KEY `site_id` (`site_id`),
            KEY `order_id` (`order_id`),
            KEY `customer_id` (`customer_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_configuration`;

        CREATE TABLE IF NOT EXISTS `prox_configuration` (
            `configuration_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `site_id` BIGINT(20) unsigned NOT NULL,
            `name` VARCHAR(255) NOT NULL,
            `value` TEXT DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
        PRIMARY KEY(`configuration_id`),
        KEY(`site_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_mail`;

        CREATE TABLE IF NOT EXISTS `prox_mail` (
            `mail_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `site_id` BIGINT(20) unsigned NOT NULL,
            `recipient` VARCHAR(255) NOT NULL,
            `template` VARCHAR(255) NOT NULL,
            `subject` TEXT DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
            PRIMARY KEY `mail_id` (`mail_id`),
            KEY `site_id` (`site_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_site`;

        CREATE TABLE IF NOT EXISTS `prox_site` (
            `site_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `name` VARCHAR(255) DEFAULT NULL,
            `email` VARCHAR(255) DEFAULT NULL,
            `domain` VARCHAR(255) DEFAULT NULL,
            `customers` INT(10) DEFAULT 0,
            `orders` INT(10) DEFAULT 0,
            `payments` FLOAT(14,2) DEFAULT 0.00,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`site_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_coupon`;

        CREATE TABLE IF NOT EXISTS `prox_coupon` (
            `coupon_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `site_id` BIGINT(20) unsigned NOT NULL,
            `coupon_code` VARCHAR(255) NOT NULL UNIQUE,
            `coupon_type` INT(10) NOT NULL DEFAULT 1,
            `coupon_value` INT(10) DEFAULT NULL,
            `writer_category_id` INT(10) DEFAULT NULL,
            `service_type_id` INT(10) DEFAULT NULL,
            `order_id` BIGINT(20) unsigned DEFAULT NULL,
            `user_id` BIGINT(20) unsigned DEFAULT NULL,
            `active` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `one_time` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `expiry` DATETIME DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`coupon_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_currency`;

        CREATE TABLE `prox_currency` (
            `currency_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `title` VARCHAR(255) NOT NULL,
            `iso_code` CHAR(5) NOT NULL UNIQUE,
            `symbol` CHAR(5) NOT NULL,
            `country_code` CHAR(5) DEFAULT NULL,
            `conversion_rate` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `active` TINYINT(1) unsigned NOT NULL DEFAULT '1',
            `last_checked` DATETIME DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
            PRIMARY KEY(`currency_id`)
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        INSERT INTO `prox_currency` (`currency_id`, `title`, `iso_code`, `symbol`, `country_code`, `conversion_rate`, `active`, `last_checked`, `date_upd`, `date_add`) VALUES
        (1, 'United States Dollars	', 'USD', '$', '', 1.00, 1, '".$date."', '".$date."', '".$date."'),
        (2, 'Pound sterling	', 'GBP', '£', '', 0.82, 1, '".$date."', '".$date."', '".$date."'),
        (3, 'Canadian Dollars	', 'CAD', '$', '', 1.33, 1, '".$date."', '".$date."', '".$date."'),
        (4, 'Australian Dollars	', 'AUD', '$', '', 1.49, 1, '".$date."', '".$date."', '".$date."');

        DROP TABLE IF EXISTS `prox_error_log`;

        CREATE TABLE `prox_error_log` (
            `log_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `site_domain` TEXT DEFAULT NULL,
            `message` TEXT DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
            PRIMARY KEY(`log_id`)
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_payment_request`;

        CREATE TABLE `prox_payment_request` (
            `payment_request_id` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
            `user_id` BIGINT(20) unsigned NOT NULL,
            `total_done_pay` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `total_completed_pay` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `total_pay` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `total_credit` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `total_fine` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `status` TINYINT(1) NOT NULL DEFAULT '0',
            `paid_at` DATETIME DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
            PRIMARY KEY(`payment_request_id`)
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_payment_request_order`;

        CREATE TABLE `prox_payment_request_order` (
            `node_id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
            `user_id` BIGINT(20) UNSIGNED NOT NULL,
            `payment_request_id` BIGINT(20) unsigned NOT NULL,
            `order_id` BIGINT(20) unsigned NOT NULL,
            PRIMARY KEY(`node_id`)
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_notification`;

        CREATE TABLE `prox_notification` (
            `notification_id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
            `to_department` VARCHAR(255) NOT NULL,
            `to_user_id` BIGINT(20) UNSIGNED NOT NULL,
            `from_department` VARCHAR(255) NOT NULL,
            `from_user_id` BIGINT(20) UNSIGNED NOT NULL,
            `action` VARCHAR(255) NOT NULL,
            `node_type` VARCHAR(255) NOT NULL,
            `node_url` VARCHAR(255) NOT NULL,
            `message` TEXT DEFAULT NULL,
            `is_seen` TINYINT(1) NOT NULL DEFAULT '0',
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
            PRIMARY KEY(`notification_id`)
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_mailing_list`;

        CREATE TABLE `prox_mailing_list` (
            `mail_id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
            `site_id` BIGINT(20) UNSIGNED NOT NULL,
            `name` VARCHAR(255) DEFAULT NULL,
            `email` VARCHAR(255) NOT NULL,
            `date_add` DATETIME DEFAULT NULL,
            PRIMARY KEY(`mail_id`)
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8;

        DROP TABLE IF EXISTS `prox_deadline`;

        CREATE TABLE `prox_deadline` (
            `deadline_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `site_id` BIGINT(20) UNSIGNED NOT NULL,
            `academic_level_id` BIGINT(20) UNSIGNED NOT NULL,
            `name` VARCHAR(255) DEFAULT NULL,
            `price_per_page` FLOAT(14,2) NOT NULL DEFAULT 0.00,
            `hrs_customer` INT(10) NOT NULL,
            `hrs_writer` INT(10) NOT NULL,
            `min_pages` INT(10) NOT NULL DEFAULT 1,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`deadline_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

        DROP TABLE IF EXISTS `prox_discipline`;

        CREATE TABLE `prox_discipline` ( 
            `discipline_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `group_id` BIGINT(20) UNSIGNED NOT NULL,
            `title` VARCHAR(255) DEFAULT NULL,
            `is_group` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `is_complex_assignment` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`discipline_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

        DROP TABLE IF EXISTS `prox_paper_type`;

        CREATE TABLE `prox_paper_type` (
            `paper_type_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `title` VARCHAR(255) DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`paper_type_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

        DROP TABLE IF EXISTS `prox_upload_type`;

        CREATE TABLE `prox_upload_type` ( 
            `upload_type_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `title` VARCHAR(255) DEFAULT NULL,
            `writer` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `customer` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `editor` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`upload_type_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

        DROP TABLE IF EXISTS `prox_paper_format`;

        CREATE TABLE `prox_paper_format` ( 
            `paper_format_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `title` VARCHAR(255) DEFAULT NULL,
            `date_upd` DATETIME DEFAULT NULL,
            `date_add` DATETIME DEFAULT NULL,
        PRIMARY KEY(`paper_format_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

        DROP TABLE IF EXISTS `prox_module`;

        /* Installed module list */
        CREATE TABLE `prox_module` (
            `module_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `name` VARCHAR(64) NOT NULL,
            `active` TINYINT(1) unsigned NOT NULL DEFAULT '0',
            `version` VARCHAR(8) NOT NULL,
            PRIMARY KEY (`module_id`),
            UNIQUE KEY `name_UNIQUE` (`name`),
            KEY `name` (`name`)
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

        DROP TABLE IF EXISTS `prox_hook`;

        CREATE TABLE `prox_hook` (
            `hook_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `name` VARCHAR(64) NOT NULL,
            `title` VARCHAR(64) NOT NULL,
            `description` TEXT,
            `position` TINYINT(1) NOT NULL DEFAULT '1',
            PRIMARY KEY (`hook_id`),
            UNIQUE KEY `hook_name` (`name`)
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

        DROP TABLE IF EXISTS `prox_hook_alias`;

        /* Hook alias name */
        CREATE TABLE `prox_hook_alias` (
            `hook_id_alias` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `alias` VARCHAR(64) NOT NULL,
            `name` VARCHAR(64) NOT NULL,
            PRIMARY KEY (`hook_id_alias`),
            UNIQUE KEY `alias` (`alias`)
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

        DROP TABLE IF EXISTS `prox_hook_module`;

        /* Define registered hook module */
        CREATE TABLE `prox_hook_module` (
            `module_id` BIGINT(20) unsigned NOT NULL,
            `hook_id` BIGINT(20) unsigned NOT NULL,
            `position` TINYINT(2) unsigned NOT NULL,
            PRIMARY KEY (
                `module_id`, `hook_id`
            ),
            KEY `hook_id` (`hook_id`),
            KEY `module_id` (`module_id`),
            KEY `position` (`position`)
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

        DROP TABLE IF EXISTS `prox_user_session`;

        CREATE TABLE IF NOT EXISTS `prox_user_session` (
            `session_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `session_token` VARCHAR(64) NOT NULL,
            `user_id` BIGINT(20) UNSIGNED NOT NULL,
            `user_browser` VARCHAR(64) NOT NULL,
            `user_os` VARCHAR(64) NOT NULL,
            `user_ip` VARCHAR(64) NOT NULL,
            `date_add` DATETIME DEFAULT NULL,
            UNIQUE KEY `session_token` (`session_token`),
            KEY `user_ip` (`user_ip`),
        PRIMARY KEY(`session_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ";

    $db->execute($structure);

    $site_id = 132457698;

    $crypto = new Hashing();
    $password = $crypto->hash(
        $password,
        PROX_COOKIE_KEY
    );

    $domain = $app->base_uri;
    $secure_key = md5(uniqid(rand(), true));

    // [4] update system settings
    $db->insert('configuration', array(
        'name' => 'SITE_ID',
        'site_id' => $site_id,
        'value' => $site_id,
        'date_add' => $date,
        'date_upd' => $date,
    ));

    $db->insert('configuration', array(
        'name' => 'SITE_DOMAIN',
        'site_id' => $site_id,
        'value' => $domain,
        'date_add' => $date,
        'date_upd' => $date,
    ));

    // [5] install preferences
    $paperTypes = $globals['paperTypes'];
    foreach( $paperTypes as $paperTypeId => $paperType ) {
        $a = new PaperType();
        $a->force_id = true;
        $a->id = $paperTypeId;
        $a->title = $paperType['title'];
        $a->add();
    }

    $paperFormats = array(
        1 => [
            "title" => "APA",
        ],
        2 => [
            "title" => "Chicago / Turabian",
        ],
        3 => [
            "title" => "Not applicable",
        ],
        4 => [
            "title" => "Other",
        ],
        5 => [
            "title" => "MLA",
        ]
    );

    foreach( $paperFormats as $paperFormatId => $paperFormat ) {
        $b = new PaperFormat();
        $b->force_id = true;
        $b->id = $paperFormatId;
        $b->title = $paperFormat['title'];
        $b->add();
    }

    $uploadTypes = $globals['uploadTypes'];
    foreach($uploadTypes as $uploadTypeId => $uploadType) {
        $c = new UploadType();
        $c->force_id = true;
        $c->id = $uploadTypeId;
        $c->title = $uploadType['description'];
        $c->writer = $uploadType['writer'];
        $c->customer = $uploadType['customer'];
        $c->add();
    }

    $disciplines = $globals['disciplines'];
    foreach($disciplines as $disciplineId => $discipline) {
        $c = new Discipline();
        $c->force_id = true;
        $c->id = $disciplineId;
        $c->title = $discipline['name'];
        $c->is_complex_assignment = $discipline['isComplexAssignment'];
        $c->add();
    }

    $disciplinesGroups = $globals['disciplinesGroups'];
    foreach( $disciplinesGroups as $disciplinesGroupId => $disciplinesGroup ) {
        $d = new Discipline();
        $d->id = $disciplinesGroupId;
        $d->title = $disciplinesGroup['groupName'];
        $d->add();

        foreach( $disciplinesGroup['disciplines'] as $disciplineId ) {
            $discipline = new Discipline( (int) $disciplineId );
            if(Validate::isLoadedObject($discipline)) {
                $discipline->group_id = $d->id;
                $discipline->update();
            }
        }
    }

    // [6] Add the admin
    try {
        $db->insert(
            'employee',
            array(
                'employee_id' => Employee::START_ID,
                'employee_group' => 1,
                'email' => $email,
                'first_name' => $first_name,
                'last_name' => $last_name,
                'password' => $password,
                'secure_key' => $secure_key,
                'is_started' => 1,
                'reg_date' => $date
            )
        );
    } catch (\Exception $e) {
        die($e->getMessage());
    }

    // [7] create config file
$config_string = "<?php
/**
 * The base configuration for Proxim
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

// ** MySQL settings - You can get this info from your web host ** //
/** The name of the database for Proxim */
define( 'DB_NAME', '".$database."' );

/** MySQL database username */
define( 'DB_USER', '".$db_user."' );

/** MySQL database password */
define( 'DB_PASSWORD', '".$db_password."' );

/** MySQL hostname */
define( 'DB_SERVER', '".$db_server."' );

/** 9 characters Unique Identifier for this site */
define( 'PROX_SITE_ID', '".$site_id."' );

/** MySQL database prefix */
define( 'DB_PREFIX', 'prox_' );

define( 'PROX_DEBUG', true );

define( 'PROX_ENVIRONMENT', 'development');

define( 'PROX_CACHING_SYSTEM', 'CacheMemcached' );

/* SQL Replication management */
define( 'PROX_USE_SQL_SLAVE', false );

/** uploads folder */
define('PROX_DIR_UPLOADS', dirname(__FILE__) . DIRECTORY_SEPARATOR . 'uploads' . DIRECTORY_SEPARATOR);

/**#@+
 * Authentication Unique Keys and Salts.
 */
define( 'PROX_COOKIE_KEY', '".PROX_COOKIE_KEY."' );
define( 'PROX_COOKIE_IV', '".PROX_COOKIE_IV."' );

/** All errors that occur will be sent to this email */
define('PROX_DEVELOPER_MAIL',          'davis@davisonpro.dev');

/* That's all, stop editing! Happy writing . */
?>";

    $config_file = PROX_DIR_ROOT . 'config.php';
    $handle = fopen($config_file, 'w') or die("Proxim intsaller wizard cannot create the config file");
    fwrite($handle, $config_string);
    fclose($handle);

    // [7] start the system
    header('Location: /');
}

?>

<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Proxim &rsaquo; Installer</title>

        <link rel="stylesheet" type="text/css" href="/static/installer/installer.css" />
        <script src="/static/installer/modernizr.custom.js"></script>
    </head>

    <body>

        <div class="container">

            <div class="fs-form-wrap" id="fs-form-wrap">

                <div class="fs-title">
                    <h1>Proxim Installer</h1>
                </div>

                <form id="myform" class="fs-form fs-form-full" autocomplete="off" action="install.php" method="post">
                    <ol class="fs-fields">

                        <li>
                            <p class="fs-field-label fs-anim-upper">
                                Welcome to <strong>Proxim</strong> installation process! Just fill in the information below and start your own academic writing service.
                            </p>
                        </li>

                        <li>
                            <label class="fs-field-label fs-anim-upper" for="db_name" data-info="The name of the database you want to run Proxim in">What's Database Name?</label>
                            <input autocomplete="off" class="fs-anim-lower" id="db_name" name="db_name" type="text" placeholder="Proxim" required/>
                        </li>

                        <li>
                            <label class="fs-field-label fs-anim-upper" for="db_username" data-info="Your MySQL username">What's Database Username?</label>
                            <input autocomplete="off" class="fs-anim-lower" id="db_username" name="db_username" type="text" placeholder="username" required/>
                        </li>

                        <li>
                            <label class="fs-field-label fs-anim-upper" for="db_password" data-info="Your MySQL password">What's Database Password?</label>
                            <input autocomplete="off" class="fs-anim-lower" id="db_password" name="db_password" type="text" placeholder="password"/>
                        </li>

                        <li>
                            <label class="fs-field-label fs-anim-upper" for="db_host" data-info="You should be able to get this info from your web host, if localhost does not work">What's Database Host?</label>
                            <input autocomplete="off" class="fs-anim-lower" id="db_host" name="db_host" type="text" placeholder="localhost" required/>
                        </li>

                        <li>
                            <label class="fs-field-label fs-anim-upper" for="admin_email" data-info="Double-check your email address before continuing.">Your E-mail</label>
                            <input autocomplete="off" class="fs-anim-lower" id="admin_email" name="admin_email" type="email" placeholder="me@mail.com" required/>
                        </li>

                        <li>
                            <label class="fs-field-label fs-anim-upper" for="admin_first_name" data-info="Name can have only alphanumeric characters.">Your First name</label>
                            <input autocomplete="off" class="fs-anim-lower" id="admin_first_name" name="admin_first_name" type="text" placeholder="First name" required/>
                        </li>

                        <li>
                            <label class="fs-field-label fs-anim-upper" for="admin_last_name" data-info="Name can have only alphanumeric characters.">Your Last name</label>
                            <input autocomplete="off" class="fs-anim-lower" id="admin_last_name" name="admin_last_name" type="text" placeholder="Last name" required/>
                        </li>

                        <li>
                            <label class="fs-field-label fs-anim-upper" for="admin_password" data-info=' The password should be at least seven characters long. To make it stronger, use upper and lower case letters, numbers, and symbols like ! " ? $ % ^ & ).'>Password</label>
                            <input autocomplete="off" class="fs-anim-lower" id="admin_password" name="admin_password" type="text" placeholder="password" required/>
                        </li>

                    </ol>
                    <button class="fs-submit" name="submit" type="submit">Install</button>
                </form>

            </div>

        </div>

        <script src="/static/installer/classie.js"></script>
        <script src="/static/installer/fullscreenForm.js"></script>
        <script>
            (function() {
                var formWrap = document.getElementById( 'fs-form-wrap' );
                new FForm( formWrap, {
                    onReview : function() {
                        classie.add( document.body, 'overview' );
                    }
                } );
            })();
        </script>

    </body>
</html>
