<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 *
 ____  ____   __  _  _  __  _  _
(  _ \(  _ \ /  \( \/ )(  )( \/ )
 ) __/ )   /(  O ))  (  )( / \/ \
(__)  (__\_) \__/(_/\_)(__)\_)(_/
*/

require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'bootstrap.php';

use Proxim\Configuration;

// Routes which do not need protection by the authentication and the request
// @TODO: Move this to a middleware
$authRouteWhitelist = [
    'home',
    'auth_register',
    'auth_login',
    'auth_logout',
    'auth_reset_password',
    'auth_reset_session',
    'theme',
    'authorizeImpersonate',
    'module',
    'fileDownload',
    'manifest'
];

$app->hook('slim.before.dispatch', function () use ($app, $authRouteWhitelist, $user, $smarty) {
    $routeName = $app->router()->getCurrentRoute()->getName();
    $controller = $app->controller;

	/** Skip routes which don't require these protections */
    if (!in_array($routeName, $authRouteWhitelist)) {
        /** Enforce required authentication. */
        $app->checkAccess($routeName);
    }
});

/**
 * Request Payload
 */
$params = $app->request->get();
$requestPayload = $app->request->post();

// $app->get('/?', '\Proxim\Dashboard\Home:index')->name('home');
$app->get('/?', '\Proxim\Dashboard\Auth:login')->name('auth_login');
$app->get('/?', '\Proxim\Dashboard\Auth:login')->name('auth_login');
$app->get('/signin?', '\Proxim\Dashboard\Auth:login')->name('auth_login');
$app->get('/login?', '\Proxim\Dashboard\Auth:login')->name('auth_login');
$app->get('/signup?', '\Proxim\Dashboard\Auth:signup')->name('auth_register');
$app->get('/forgot-password?', '\Proxim\Dashboard\Auth:forgotPassword')->name('auth_reset_password');
$app->get('/reset/:reset_key?', '\Proxim\Dashboard\Auth:resetPassword')->name('auth_reset_password');
$app->get('/authorize/impersonate?', '\Proxim\Dashboard\Auth:authorizeImpersonate')->name('authorizeImpersonate');
$app->get('/authorize/:employeeId/:authKey?', '\Proxim\Dashboard\Auth:authorize')->name('authorize');

#pwa
if(Configuration::get('PWA_ENABLED')) {
    $app->get('/manifest.json?', '\Proxim\Dashboard\PWA:manifest')->name('manifest');
    $app->get('/serviceWorker.js?', '\Proxim\Dashboard\PWA:serviceWorker')->name('manifest');
}

# started
$app->get('/started?', '\Proxim\Dashboard\Onboarding:started')->name('started');
$app->get('/application?', '\Proxim\Dashboard\Onboarding:application')->name('application');
$app->get('/application/:sub_view?', '\Proxim\Dashboard\Onboarding:application')->name('application');

# logout 
$app->get('/logout', function () use ($app, $user) {
	$user->logout();
    $app->redirect('/');
})->name('auth_logout');

# messages
$app->get('/messages?', '\Proxim\Dashboard\Messages:getMessages');

# notifications
$app->get('/notifications?', '\Proxim\Dashboard\Notifications:getNotifications');

#Orders
$app->get('/orders?', '\Proxim\Dashboard\Orders:getOrders');
$app->get('/orders/create?', '\Proxim\Dashboard\Orders:createOrder');
$app->get('/orders/:status?', '\Proxim\Dashboard\Orders:getOrders');
$app->get('/orders/:user_group/:user_id?', '\Proxim\Dashboard\Orders:getUserOrders');
$app->get('/order/:orderId?', '\Proxim\Dashboard\Orders:getOrder');
$app->get('/order/:orderId/edit?', '\Proxim\Dashboard\Orders:editOrder');
$app->get('/order/:orderId/:sub_view?', '\Proxim\Dashboard\Orders:getOrder');

#Profile
$app->get('/profile?', '\Proxim\Dashboard\Profile:profile');
$app->get('/settings/:_settings?', '\Proxim\Dashboard\Profile:profile');

#Feedback
$app->get('/feedback?', '\Proxim\Dashboard\Feedback:index');
$app->get('/feedback/:feedbackId?', '\Proxim\Dashboard\Feedback:viewFeedback');
$app->get('/feedback/employee/:employeeId?', '\Proxim\Dashboard\Feedback:viewEmployeeFeedback');

#Ratings
$app->get('/ratings?', '\Proxim\Dashboard\Ratings:index');

#financial overview
$app->get('/financial-overview?', '\Proxim\Dashboard\Payments:financialOverview');
$app->get('/financial-overview/:sub_view?', '\Proxim\Dashboard\Payments:financialOverview');

#performance overview
$app->get('/performance?', '\Proxim\Dashboard\Performance:index');

#payments
$app->get('/payments?', '\Proxim\Dashboard\Payments:payments');
$app->get('/payments/:sub_view?', '\Proxim\Dashboard\Payments:payments');
$app->get('/payments/download/:payment_id?', '\Proxim\Dashboard\Payments:downloadPaymentRequests');

#mailing
$app->group('/mailing', function () use ($app) {
    $app->get('/mails?', '\Proxim\Dashboard\Mailing:mails');
    $app->get('/send?', '\Proxim\Dashboard\Mailing:sendMail');
    $app->get('/add?', '\Proxim\Dashboard\Mailing:addMail');
    $app->get('/edit/:customer_id?', '\Proxim\Dashboard\Mailing:editMail');
    $app->get('/templates?', '\Proxim\Dashboard\Mailing:templates');
    $app->get('/templates/:tab?', '\Proxim\Dashboard\Mailing:templates');
});

#guides
$app->group('/guides', function () use ($app) {
    $app->get('/writing-guide?', '\Proxim\Dashboard\Guides:writing');
    $app->get('/payment-guide?', '\Proxim\Dashboard\Guides:payment');
    $app->get('/faqs', '\Proxim\Dashboard\Guides:faq');
});

#info
$app->group('/info', function () use ($app) {
    $app->get('/:sub_view', '\Proxim\Dashboard\Info:guide');
    $app->get('/:sub_view/add?', '\Proxim\Dashboard\Info:addGuide');
    $app->get('/:sub_view/edit/:guide_id?', '\Proxim\Dashboard\Info:editGuide');
});

#users
$app->group('/customers', function () use ($app) {
    $app->get('/?', '\Proxim\Dashboard\Users:customers');
    $app->get('/:sub_view?', '\Proxim\Dashboard\Users:customers');
    $app->get('/:sub_view/:customer_id?', '\Proxim\Dashboard\Users:customers');
});

$app->group('/employees', function () use ($app) {
    $app->get('/:sub_view?', '\Proxim\Dashboard\Users:employees');
    $app->get('/:sub_view/:employee_id?', '\Proxim\Dashboard\Users:employees');
});

#applications
$app->group('/applications', function () use ($app) {
    $app->get('/', '\Proxim\Dashboard\WriterApplications:writerApplications');
    $app->get('/essays?', '\Proxim\Dashboard\WriterApplications:essays');
    $app->get('/writing-prompts?', '\Proxim\Dashboard\WriterApplications:writingPrompts');
    $app->get('/settings?', '\Proxim\Dashboard\WriterApplications:settings');
    $app->get('/:status', '\Proxim\Dashboard\WriterApplications:writerApplications');
});

#coupons
$app->get('/coupons?', '\Proxim\Dashboard\Coupons:coupons');
$app->get('/coupons/:sub_view?', '\Proxim\Dashboard\Coupons:coupons');
$app->get('/coupons/:sub_view/:coupon_id?', '\Proxim\Dashboard\Coupons:coupons');

#pools
$app->get('/pools?', '\Proxim\Dashboard\WriterPools:pools');
$app->get('/pools/add?', '\Proxim\Dashboard\WriterPools:addPool');
$app->get('/pools/view/:id?', '\Proxim\Dashboard\WriterPools:viewPool');

# sites
$app->group('/my-sites', function () use ($app) {
    $app->get('/?', '\Proxim\Dashboard\MySites:viewSites');
    $app->get('/add?', '\Proxim\Dashboard\MySites:addSite');
    
    $app->group('/:site_id', function () use ($app) {
        $app->get('/?', '\Proxim\Dashboard\MySites:editSite');
        $app->get('/edit?', '\Proxim\Dashboard\MySites:editSite');
        $app->get('/preferences?', '\Proxim\Dashboard\MySites:preferences');
        $app->get('/deadlines?', '\Proxim\Dashboard\MySites:deadlines');
        $app->get('/deadlines/:sub_view?', '\Proxim\Dashboard\MySites:deadlines');
    });
});

# modules
$app->get('/modules?', '\Proxim\Dashboard\Modules:catalogue');
$app->get('/modules/catalogue?', '\Proxim\Dashboard\Modules:catalogue');
$app->get('/modules/installed?', '\Proxim\Dashboard\Modules:installedModules');
$app->get('/modules/purchase/:moduleName?', '\Proxim\Dashboard\Modules:purchaseModule');

# updates
$app->get('/updates?', '\Proxim\Dashboard\Updates:index');

$app->group('/system', function () use ($app) {
    #system
    $app->get('/settings?', '\Proxim\Dashboard\Admin:settings');

    #orders-payments
    $app->get('/orders-payments?', '\Proxim\Dashboard\Admin:ordersPaymentsSettings');

    #uploads
    $app->get('/uploads?', '\Proxim\Dashboard\Admin:uploads');

    #themes
    $app->get('/themes?', '\Proxim\Dashboard\Admin:themes');
    
    #payments
    $app->get('/payments?', '\Proxim\Dashboard\Admin:payments');
    # currency
    $app->get('/currency?', '\Proxim\Dashboard\Admin:currency');
    $app->get('/currency/:sub_view?', '\Proxim\Dashboard\Admin:currency');
    $app->get('/currency/:sub_view/:currency_id?', '\Proxim\Dashboard\Admin:currency');
});

#preferences
$app->group('/preferences', function () use ($app) {
    $app->get('/', '\Proxim\Dashboard\Preferences:general');

    $app->group('/general', function () use ($app) {
        $app->get('/', '\Proxim\Dashboard\Preferences:general');
        $app->get('/:sub_view?', '\Proxim\Dashboard\Preferences:general');
    });

    $app->group('/academic', function () use ($app) {
        $app->get('/', '\Proxim\Dashboard\Preferences:academicWriting');
        $app->get('/:sub_view?', '\Proxim\Dashboard\Preferences:academicWriting');
    });

    $app->group('/calculations', function () use ($app) {
        $app->get('/', '\Proxim\Dashboard\Preferences:calculations');
        $app->get('/:sub_view?', '\Proxim\Dashboard\Preferences:calculations');
    });

    $app->group('/programming', function () use ($app) {
        $app->get('/', '\Proxim\Dashboard\Preferences:programming');
        $app->get('/:sub_view?', '\Proxim\Dashboard\Preferences:programming');
    });

    $app->group('/articles', function () use ($app) {
        $app->get('/', '\Proxim\Dashboard\Preferences:articleWriting');
        $app->get('/:sub_view?', '\Proxim\Dashboard\Preferences:articleWriting');
    });

});

$app->group('/api', function () use ($app) {
    # auth
    $app->post('/signin?', '\Proxim\Api\Auth:signin')->name('auth_login');
    $app->post('/signup?', '\Proxim\Api\Auth:signup')->name('auth_register');
    $app->post('/reset-password?', '\Proxim\Api\Auth:resetPassword')->name('auth_reset_password');
    $app->post('/forget-password-confirm?', '\Proxim\Api\Auth:changePassword')->name('auth_reset_password');

    $app->get('/ifs/download/:fileId?', '\Proxim\Api\Files:downloadFile')->name('fileDownload');

    # order
    $app->post('/order?', '\Proxim\Api\Orders:createOrder');

    #orders
    $app->group('/orders', function () use ($app) {
        $app->get('/createOrder?', '\Proxim\Api\Orders:showCustomersModal');
        
        #files
        $app->post('/:order_id/upload_files', '\Proxim\Api\Orders:uploadFiles');
        $app->get('/:order_id/download_all_attachments?', '\Proxim\Api\Files:downloadAllAttachments');

        $app->post('/:order_id?', '\Proxim\Api\Orders:order');
        $app->post('/:order_id/:do?', '\Proxim\Api\Orders:order');
    });

    #messages
    $app->group('/messages', function () use ($app) {
        $app->post('/send?', '\Proxim\Api\Orders:sendMessage');
        $app->post('/:id/reply?', '\Proxim\Api\Orders:replyMessage');
        $app->post('/:id/read?', '\Proxim\Api\Orders:readMessage');
    });

    #files
    $app->group('/files', function () use ($app) {
        $app->get('/:file_id/download?', '\Proxim\Api\Files:downloadFile');
        $app->post('/upload?', '\Proxim\Api\Files:uploadFiles');
    });

    #pools
    $app->post('/pools/post?', '\Proxim\Api\WriterPools:post');
    $app->post('/pools/addwriter?', '\Proxim\Api\WriterPools:addwriter');

    $app->post('/application/:action?', '\Proxim\Api\Onboarding:application')->name('application');

    $app->get('/employee-files/:file_id/download?', '\Proxim\Api\Files:downloadEmployeeFile');

    #feedback
    $app->group('/feedback', function () use ($app) {
        $app->post('/survey?', '\Proxim\Api\Preferences:survey')->name('auth_login');
        $app->post('/:feedback_id/reply?', '\Proxim\Api\Orders:feedbackReply');
    });
 
    #profile
    $app->post('/user/settings?', '\Proxim\Api\Profile:editProfile');
    $app->post('/user/remove-picture?', '\Proxim\Api\Profile:removePicture');
    $app->post('/user/session?', '\Proxim\Api\Profile:session');

    #request payment
    $app->post('/user/request-payment?', '\Proxim\Api\Profile:requestPayment');
    $app->get('/user/payment-requests/:request_id?', '\Proxim\Api\Admin:getPaymentRequestOrders');

    #users
    $app->post('/customers?', '\Proxim\Api\Users:customers');
    $app->post('/employees/:do?', '\Proxim\Api\Users:employees');

    # auth
    $app->post('/theme?', '\Proxim\Api\Profile:setTheme')->name('theme');

    $app->post('/modules/upload?', '\Proxim\Api\Modules:uploadPlugin');

    # admin
    $app->group('/admin', function () use ($app) {
        # modules
        $app->post('/applications?', '\Proxim\Api\WriterApplications:applications');
        # modules
        $app->post('/modules?', '\Proxim\Api\Modules:doAction');
        # themes
        $app->post('/themes?', '\Proxim\Api\Themes:doAction');
        # bulk actions
        $app->post('/bulk-actions?', '\Proxim\Api\Orders:bulkActions');
        #mailing
        $app->post('/mailing?', '\Proxim\Api\Mailing:mailing');
        #delete
        $app->post('/delete?', '\Proxim\Api\Admin:delete');
        #settings
        $app->post('/settings?', '\Proxim\Api\Admin:settings');
        #sites
        $app->post('/sites?', '\Proxim\Api\MySites:updateSettings');
        #currency
        $app->post('/currency?', '\Proxim\Api\Currency:currency');
        #coupon
        $app->post('/coupon?', '\Proxim\Api\Coupons:coupon');
        #test
        $app->post('/test?', '\Proxim\Api\Admin:test');
        #withdraw
        $app->post('/withdraw?', '\Proxim\Api\Admin:withdraw');
        # password reset link
        $app->post('/password-reset-link?', '\Proxim\Api\Users:generateResetLink');
    });

    #preferences
    $app->post('/preferences?', '\Proxim\Api\Preferences:index');

    #info
    $app->group('/info', function () use ($app) {
        $app->post('/:sub_view/:action?', '\Proxim\Api\Info:guide');
    });

    #applications
    $app->group('/applications', function () use ($app) {
        $app->post('/essays/:action', '\Proxim\Api\WriterApplications:essays');
        $app->post('/writing-prompt/:action', '\Proxim\Api\WriterApplications:writingPrompts');
    });

    #data
    $app->group('/data', function () use ($app) {
        $app->post('/live?', '\Proxim\Api\Updates:getLiveData');
        $app->post('/reset?', '\Proxim\Api\Updates:reset');
        $app->post('/load?', '\Proxim\Api\Updates:load');
        $app->post('/autocomplete?', '\Proxim\Api\Updates:autocomplete');

        #upload
        $app->post('/upload?', '\Proxim\Api\Files:dataUpload');
    });

    $app->get('/:module_name/:controller?', '\Proxim\Dashboard\Modules:initModule')->name('module');
    $app->post('/:module_name/:controller?', '\Proxim\Dashboard\Modules:initModule')->name('module');
});

$app->get('/:module_name', '\Proxim\Dashboard\Modules:initModule')->name('module');
$app->get('/:module_name/:controller?', '\Proxim\Dashboard\Modules:initModule')->name('module');

$app->notFound(function () use ($app) {
    $app->response->status(404);
    if ($app->request->isAjax()) {
        $app->response()->header('Content-Type', 'application/json; charset=utf-8');
        $app->response([
            "error" => true,
            "message" => "Error 404. Resource not found"
        ]);
    } else {
        $app->response()->header('Content-Type', 'text/html; charset=utf-8');
        $html = $app->smarty->fetch('404.tpl');
        echo trim($html);
    }

    return $app->stop();
});

// Run Slim
$app->response()->header('Content-Type', 'application/json; charset=utf-8');
$app->run();
