{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
<div class="card">
    <!-- card-header -->
    <div class="card-header with-icon with-nav">
        <!-- panel title -->
        <div class="mb20">
            <i class="fa fa-cog mr10"></i>Settings &rsaquo; Uploads
        </div>
        <!-- panel title -->

        <!-- panel nav -->
        <ul class="nav nav-tabs">
            <li class="nav-item">
                <a class="nav-link active" href="#General" data-toggle="tab">
                    <i class="fa fa-upload fa-fw mr5"></i><strong class="pr5">General</strong>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#S3" data-toggle="tab">
                    <i class="fab fa-amazon fa-fw mr5"></i><strong class="pr5">Amazon S3</strong>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#DigitalOcean" data-toggle="tab">
                    <i class="fab fa-digital-ocean fa-fw mr5"></i><strong class="pr5">DigitalOcean</strong>
                </a>
            </li>
        </ul>
        <!-- panel nav -->
    </div>
    <!-- card-header -->

    <!-- tabs content -->
    <div class="tab-content">
        <!-- General -->
        <div class="tab-pane active" id="General">
            <form class="js_ajax-forms" data-url="/admin/settings?edit=uploads">
                <div class="card-body">
                    <div class="alert alert-warning"> 
                        <div class="icon"> 
                            <i class="fa fa-exclamation-triangle fa-2x"></i> 
                        </div> 
                        <div class="text">
                            Your server max upload size = {$max_upload_size}<br>
                            You can't upload files larger than {$max_upload_size} - To upload larger files, contact your hosting provider
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Internal File Storage</div> 
                            <div class="form-text">Allow each site to store it's own files. Enable this option if your sites are hosted in separate cPanel accounts.</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="internal_file_storage"> 
                                <input type="checkbox" name="internal_file_storage" id="internal_file_storage" {if $formValues.INTERNAL_FILE_STORAGE}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Shared Folder Storage</div> 
                            <div class="form-text">Enable this if your client sites are hosted in different cPanel accounts.</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="shared_folder_permissions"> 
                                <input type="checkbox" name="shared_folder_permissions" id="shared_folder_permissions" {if $formValues.SHARED_FOLDER_PERMISSIONS}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="divider"></div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            File Extensions
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="file_extensions" value="{$formValues.ALLOWED_EXTENSIONS}">
                            <span class="help-block">
                                Allowed file extensions without the dot (separated with comma ',)
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                        </div>
                    </div>
                </div>
                <div class="card-footer text-right">
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
        <!-- General -->

        <!-- S3 -->
        <div class="tab-pane" id="S3">
            <form class="js_ajax-forms " data-url="/admin/settings?edit=s3">
                <div class="card-body">
                    <div class="alert alert-info">
                        <div class="icon">
                            <i class="fab fa-amazon fa-2x"></i>
                        </div>
                        <div class="text">
                            <strong>Amazon S3 Storage</strong><br>
                            Before enabling Amazon S3, make sure you upload the whole 'uploads' folder to your bucket.<br>
                            Before disabling Amazon S3, make sure you download the whole 'uploads' folder to your server.
                        </div>
                    </div>

                    <div class="form-table-row">
                        <div>
                            <div class="form-control-label h5">Amazon S3 Storage</div>
                            <div class="form-text">
                                Enable Amazon S3 storage (Note: Enable this will disable all other options)
                            </div>
                        </div>
                        <div class="text-right">
                            <label class="switch" for="s3_enabled">
                                <input type="checkbox" name="s3_enabled" id="s3_enabled" {if $formValues.S3_ENABLED}checked{/if}>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-md-3 form-control-label">
                            Bucket Name
                        </label>
                        <div class="col-md-9">
                            <input type="text" class="form-control" name="s3_bucket" value="{$formValues.S3_BUCKET}">
                            <span class="form-text">
                                Your Amazon S3 bucket name
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-md-3 form-control-label">
                            Bucket Region
                        </label>
                        <div class="col-md-9">
                            <select name="s3_region" class="form-control">
                                <option value="us-east-2" {if $formValues.S3_REGION == "us-east-2"}selected{/if}>US East (Ohio)</option>
                                <option value="us-east-1" {if $formValues.S3_REGION == "us-east-1"}selected{/if}>US East (N. Virginia)</option>
                                <option value="us-west-1" {if $formValues.S3_REGION == "us-west-1"}selected{/if}>US West (N. California)</option>
                                <option value="us-west-2" {if $formValues.S3_REGION == "us-west-2"}selected{/if}>US West (Oregon)</option>
                                <option value="ap-east-1" {if $formValues.S3_REGION == "ap-east-1"}selected{/if}>Asia Pacific (Hong Kong)</option>
                                <option value="ap-south-1" {if $formValues.S3_REGION == "ap-south-1"}selected{/if}>Asia Pacific (Mumbai)</option>
                                <option value="ap-northeast-3" {if $formValues.S3_REGION == "ap-northeast-3"}selected{/if}>Asia Pacific (Osaka-Local)</option>
                                <option value="ap-northeast-2" {if $formValues.S3_REGION == "ap-northeast-2"}selected{/if}>Asia Pacific (Seoul)</option>
                                <option value="ap-southeast-1" {if $formValues.S3_REGION == "ap-southeast-1"}selected{/if}>Asia Pacific (Singapore)</option>
                                <option value="ap-southeast-2" {if $formValues.S3_REGION == "ap-southeast-2"}selected{/if}>Asia Pacific (Sydney)</option>
                                <option value="ap-northeast-1" {if $formValues.S3_REGION == "ap-northeast-1"}selected{/if}>Asia Pacific (Tokyo)</option>
                                <option value="ca-central-1" {if $formValues.S3_REGION == "ca-central-1"}selected{/if}>Canada (Central)</option>
                                <option value="eu-central-1" {if $formValues.S3_REGION == "eu-central-1"}selected{/if}>EU (Frankfurt)</option>
                                <option value="eu-west-1" {if $formValues.S3_REGION == "eu-west-1"}selected{/if}>EU (Ireland)</option>
                                <option value="eu-west-2" {if $formValues.S3_REGION == "eu-west-2"}selected{/if}>EU (London)</option>
                                <option value="eu-west-3" {if $formValues.S3_REGION == "eu-west-3"}selected{/if}>EU (Paris)</option>
                                <option value="eu-north-1" {if $formValues.S3_REGION == "eu-north-1"}selected{/if}>Europe (Stockholm)</option>
                                <option value="me-south-1" {if $formValues.S3_REGION == "me-south-1"}selected{/if}>Middle East (Bahrain)</option>
                                <option value="sa-east-1" {if $formValues.S3_REGION == "sa-east-1"}selected{/if}>South America (São Paulo)</option>
                            </select>
                            <span class="form-text">
                                Your Amazon S3 bucket region
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-md-3 form-control-label">
                            Access Key ID
                        </label>
                        <div class="col-md-9">
                            <input type="text" class="form-control" name="s3_key" value="{$formValues.S3_KEY}">
                            <span class="form-text">
                                Your Amazon S3 Access Key ID
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-md-3 form-control-label">
                            Access Key Secret
                        </label>
                        <div class="col-md-9">
                            <input type="text" class="form-control" name="s3_secret" value="{$formValues.S3_SECRET}">
                            <span class="form-text">
                                Your Amazon S3 Access Key Secret
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                        </div>
                    </div>
                </div>
                <div class="card-footer text-right">
                    <button type="button" class="btn btn-danger js_admin-tester" data-handle="s3">
                        <i class="fa fa-bolt mr10"></i> Test Connection
                    </button>
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
        <!-- S3 -->

        <!-- DigitalOcean -->
        <div class="tab-pane" id="DigitalOcean">
            <form class="js_ajax-forms " data-url="/admin/settings?edit=digitalocean">
                <div class="card-body">
                    <div class="alert alert-info">
                        <div class="icon">
                            <i class="fab fa-digital-ocean fa-2x"></i>
                        </div>
                        <div class="text">
                            <strong>DigitalOcean</strong><br>
                            Before enabling DigitalOcean Space, make sure you upload the whole 'uploads' folder to your space.<br>
                            Before disabling DigitalOcean Space, make sure you download the whole 'uploads' folder to your server.
                        </div>
                    </div>

                    <div class="form-table-row">
                        <div>
                            <div class="form-control-label h5">DigitalOcean Space</div>
                            <div class="form-text">
                                Enable DigitalOcean storage (Note: Enable this will disable all other options)
                            </div>
                        </div>
                        <div class="text-right">
                            <label class="switch" for="digitalocean_enabled">
                                <input type="checkbox" name="digitalocean_enabled" id="digitalocean_enabled" {if $formValues.DIGITALOCEAN_ENABLED}checked{/if}>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-md-3 form-control-label">
                            Space Name
                        </label>
                        <div class="col-md-9">
                            <input type="text" class="form-control" name="digitalocean_space_name" value="{$formValues.DIGITALOCEAN_SPACE_NAME}">
                            <span class="form-text">
                                Your DigitalOcean space name
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-md-3 form-control-label">
                            Space Region
                        </label>
                        <div class="col-md-9">
                            <select name="digitalocean_space_region" class="form-control">
                                <option value="sfo2" {if $formValues.DIGITALOCEAN_SPACE_REGION == "sfo2"}selected{/if}>San Francisco</option>
                                <option value="nyc3" {if $formValues.DIGITALOCEAN_SPACE_REGION == "nyc3"}selected{/if}>New York</option>
                                <option value="ams3" {if $formValues.DIGITALOCEAN_SPACE_REGION == "ams3"}selected{/if}>Amsterdam</option>
                                <option value="sgp1" {if $formValues.DIGITALOCEAN_SPACE_REGION == "sgp1"}selected{/if}>Singapore</option>
                                <option value="fra1" {if $formValues.DIGITALOCEAN_SPACE_REGION == "fra1"}selected{/if}>Frankfurt</option>
                            </select>
                            <span class="form-text">
                                Your DigitalOcean space region
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-md-3 form-control-label">
                            Access Key ID
                        </label>
                        <div class="col-md-9">
                            <input type="text" class="form-control" name="digitalocean_key" value="{$formValues.DIGITALOCEAN_KEY}">
                            <span class="form-text">
                                Your DigitalOcean Access Key ID
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-md-3 form-control-label">
                            Access Key Secret
                        </label>
                        <div class="col-md-9">
                            <input type="text" class="form-control" name="digitalocean_secret" value="{$formValues.DIGITALOCEAN_SECRET}">
                            <span class="form-text">
                                Your DigitalOcean Access Key Secret
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                        </div>
                    </div>
                </div>
                <div class="card-footer text-right">
                    <button type="button" class="btn btn-danger js_admin-tester" data-handle="digitalocean">
                        <i class="fa fa-bolt mr10"></i> Test Connection
                    </button>
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
        <!-- DigitalOcean -->

    </div>
</div>
{/block}