{if count($disciplines)}
    <div class="table-responsive">
        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
            <thead>
                <tr>
                    <th>Discipline</th>
                    <th>Task Size</th>
                    <th>Price</th>
                    <th>Actions</th>
                </tr>
            </thead> 
            <tbody>
                {foreach $disciplines as $discipline}
                    <tr>
                        <th colspan="4">{$discipline.title}</th>
                    </tr>
                    {if isset($itemPricesByDiscipline[$discipline.discipline_id])}
                        {foreach $itemPricesByDiscipline[$discipline.discipline_id] as $itemPrice}
                            <tr>
                                <th>&nbsp;</th>
                                <th id="co3" headers="blank">
                                    {$itemPrice.task_size_title}
                                </th>
                                <th id="co3" headers="blank">
                                    <span class="text-success">{$itemPrice.priceFormatted}</span>
                                </th>
                                <th id="co4" headers="blank">
                                    <div class="dropdown">
                                        <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$itemPrice.item_pricing_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Actions
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$itemPrice.item_pricing_id}">
                                            <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editItemPricingModal-{$itemPrice.item_pricing_id}" data-size="medium" data-options='{$itemPrice|json_encode nofilter}'>
                                                <i class="fa fa-pencil-alt mr5"></i> Edit
                                            </a>
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="item_pricing" data-id="{$itemPrice.item_pricing_id}">
                                                <i class="fa fa-trash mr5"></i> Delete
                                            </a>
                                        </div>
                                    </div>

                                    <!-- Add Item Pricing -->
                                    <script id="editItemPricingModal-{$itemPrice.item_pricing_id}" type="text/template">
                                        <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editItemPricing" method="POST" autocomplete="off">
                                            <input type="hidden" name="item_pricing_id" value="{$itemPrice.item_pricing_id}">
                                            <input type="hidden" name="is_programming" value="1">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Edit Item Pricing</h5>
                                                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                                                    <i class="fa fa-times"></i>
                                                </span>
                                            </div>

                                            <div class="modal-body">
                                                <div class="form-group">
                                                    <label class="control-label">Discipline</label>
                                                    <select class="form-control" name="discipline_id">
                                                        {foreach $disciplines as $discipline}
                                                            <option value="{$discipline.discipline_id}" {if $itemPrice.discipline_id == $discipline.discipline_id}selected{/if}>{$discipline.title}</option>
                                                        {/foreach}
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <label class="control-label">Task Size</label>
                                                    <div class="">
                                                        <div class="selectgroup btn-fullwidth">
                                                            {foreach from=$taskSizes item=$taskSize key=$sizeId}
                                                                <label class="selectgroup-item" id="task_size_{$sizeId}">
                                                                    <input for="task_size_{$sizeId}" type="radio" name="task_size" {if $itemPrice.task_size_id == $sizeId}checked=""{/if} value="{$sizeId}" class="selectgroup-input">
                                                                    <span class="selectgroup-button">{$taskSize.title}</span>
                                                                </label>
                                                            {/foreach}
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="form-group">
                                                    <label class="control-label text-left">Price</label>
                                                    <div class="row">
                                                        <div class="input-group col-md-4">
                                                            <div class="input-group-prepend"> 
                                                                <span class="input-group-text">$</span> 
                                                            </div>
                                                            <input name="price" type="text" class="form-control force-integer" value="{$itemPrice.price}">
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <!-- success -->
                                                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                                                <!-- success -->

                                                <!-- error -->
                                                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                                                <!-- error -->
                                            </div>
                                            
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
                                            </div>
                                        </form>
                                    </script>
                                    <!-- Add Item Pricing -->
                                </th>
                            </tr>
                        {/foreach}
                    {/if}
                    
                {/foreach}
            </tbody>
        </table>

        {$pager nofilter}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No pricing to show</strong></p>
    </div>
{/if}

<!-- Add Item Pricing -->
<script id="addItemPricingModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addItemPricing" method="POST" autocomplete="off">
        <input type="hidden" name="is_programming" value="1">
        <div class="modal-header">
            <h5 class="modal-title">Add Item Pricing</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Discipline</label>
                <select class="form-control" name="discipline_id">
                    {foreach $disciplines as $discipline}
                        <option value="{$discipline.discipline_id}">{$discipline.title}</option>
                    {/foreach}
                </select>
            </div>

            <div class="form-group">
                <label class="control-label">Task Size</label>
                <div class="">
                    <div class="selectgroup btn-fullwidth">
                        {foreach from=$taskSizes item=$taskSize key=$sizeId}
                            <label class="selectgroup-item" id="task_size_{$sizeId}">
                                <input for="task_size_{$sizeId}" type="radio" name="task_size" {if $sizeId == '1'}checked=""{/if} value="{$sizeId}" class="selectgroup-input">
                                <span class="selectgroup-button">{$taskSize.title}</span>
                            </label>
                        {/foreach}
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label class="control-label text-left">Price</label>
                <div class="row">
                    <div class="input-group col-md-4">
                        <div class="input-group-prepend"> 
                            <span class="input-group-text">$</span> 
                        </div>
                        <input name="price" type="text" class="form-control force-integer">
                    </div>
                </div>
            </div>
            
            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Item Pricing</button>
        </div>
    </form>
</script>
<!-- Add Item Pricing -->