{if count($disciplines)}
    <div class="table-responsive">
        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
            <thead>
                <tr>
                    <th width="15%">Discipline</th>
                    <th>Tasks</th>
                    <th>Deliverables</th>
                    <th>Actions</th>
                </tr>
            </thead> 
            <tbody>
                {foreach $disciplines as $discipline}
                    <tr>
                        <th colspan="4">{$discipline.title}</th>
                    </tr>
                    {if isset($descriptorsByDiscipline[$discipline.discipline_id])}
                        {foreach $descriptorsByDiscipline[$discipline.discipline_id] as $descriptor}
                            <tr>
                                <th>&nbsp;</th>
                                <th id="co3" headers="blank">
                                    {$descriptor.task_size_title}
                                </th>
                                <th width="60%" headers="blank">
                                    <div class="text-muted mb5">{$descriptor.example}</div>
                                    <ul class="task_deliverables">
                                        {foreach $descriptor.deliverables as $deliverable}
                                            <li class="task_deliverables_item task_deliverables_item--{$deliverable.slug}">{$deliverable.name}</li>
                                        {/foreach}
                                    </ul>
                                </th>
                                <th id="co4" headers="blank">
                                    <div class="dropdown">
                                        <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$descriptor.descriptor_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Actions
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$descriptor.descriptor_id}">
                                            <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editDescriptorModal-{$descriptor.descriptor_id}" data-size="medium" data-options='{$descriptor|json_encode nofilter}'>
                                                <i class="fa fa-pencil-alt mr5"></i> Edit
                                            </a>
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="descriptor" data-id="{$descriptor.descriptor_id}">
                                                <i class="fa fa-trash mr5"></i> Delete
                                            </a>
                                        </div>
                                    </div>
                                    
                                    <!-- Edit Descriptor -->
                                    <script id="editDescriptorModal-{$descriptor.descriptor_id}" type="text/template">
                                        <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editDescriptor" method="POST" autocomplete="off">
                                            <input type="hidden" name="descriptor_id" value="{$descriptor.descriptor_id}">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Edit Descriptor</h5>
                                                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                                                    <i class="fa fa-times"></i>
                                                </span>
                                            </div>

                                            <div class="modal-body">
                                                <div class="form-group">
                                                    <label class="control-label">Discipline</label>
                                                    <select class="form-control" name="discipline_id">
                                                        {foreach $disciplines as $discipline}
                                                            <option value="{$discipline.discipline_id}" {if $discipline.discipline_id == $descriptor.discipline_id}selected{/if}>{$discipline.title}</option>
                                                        {/foreach}
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <label class="control-label">Example</label>
                                                    <input name="example" type="text" class="form-control" value="{$descriptor.example}" required>
                                                </div>

                                                <div class="form-group">
                                                    <label class="control-label">Task Size</label>
                                                    <div class="">
                                                        <div class="selectgroup btn-fullwidth">
                                                            {foreach from=$taskSizes item=$taskSize key=$sizeId}
                                                                <label class="selectgroup-item" id="task_size_{$sizeId}">
                                                                    <input for="task_size_{$sizeId}" type="radio" name="task_size" {if $descriptor.task_size_id == $sizeId}checked=""{/if} value="{$sizeId}" class="selectgroup-input">
                                                                    <span class="selectgroup-button">{$taskSize.title}</span>
                                                                </label>
                                                            {/foreach}
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="form-group">
                                                    <label class="control-label">Possible deliverables</label>
                                                    <div class="">
                                                        <div class="selectgroup btn-fullwidth">
                                                            <select class="form-control" name="deliverables[]" multiple="" size="10">
                                                                {foreach $deliverables as $deliverable}
                                                                    <option value="{$deliverable.deliverable_id}" {if isset($descriptor.deliverables[$deliverable.deliverable_id])}selected{/if}>{$deliverable.name}</option>
                                                                {/foreach}
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <!-- success -->
                                                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                                                <!-- success -->

                                                <!-- error -->
                                                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                                                <!-- error -->
                                            </div>
                                            
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
                                            </div>
                                        </form>
                                    </script>
                                    <!-- Edit Descriptor -->
                                </th>
                            </tr>
                        {/foreach}
                    {/if}
                {/foreach}
            </tbody>
        </table>

        {$pager nofilter}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No task sizes to show</strong></p>
    </div>
{/if}

<!-- Add Descriptor -->
<script id="addDescriptorModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addDescriptor" method="POST" autocomplete="off">
        <input type="hidden" name="is_programming" value="1">
        <div class="modal-header">
            <h5 class="modal-title">Add Descriptor</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Discipline</label>
                <select class="form-control" name="discipline_id">
                    {foreach $disciplines as $discipline}
                        <option value="{$discipline.discipline_id}">{$discipline.title}</option>
                    {/foreach}
                </select>
            </div>

            <div class="form-group">
                <label class="control-label">Example</label>
                <input name="example" type="text" class="form-control" required>
            </div>

            <div class="form-group">
                <label class="control-label">Task Size</label>
                <div class="">
                    <div class="selectgroup btn-fullwidth">
                        {foreach from=$taskSizes item=$taskSize key=$sizeId}
                            <label class="selectgroup-item" id="task_size_{$sizeId}">
                                <input for="task_size_{$sizeId}" type="radio" name="task_size" {if $sizeId == '1'}checked=""{/if} value="{$sizeId}" class="selectgroup-input">
                                <span class="selectgroup-button">{$taskSize.title}</span>
                            </label>
                        {/foreach}
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label class="control-label">Possible deliverables</label>
                <div class="">
                    <div class="selectgroup btn-fullwidth">
                        <select class="form-control" name="deliverables[]" multiple="" size="10">
                            {foreach $deliverables as $deliverable}
                                <option value="{$deliverable.deliverable_id}">{$deliverable.name}</option>
                            {/foreach}
                        </select>
                    </div>
                </div>
            </div>
            
            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Descriptor</button>
        </div>
    </form>
</script>
<!-- Add Descriptor -->