{if count($deliverables)}
    <div class="table-responsive">
        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                {foreach $deliverables as $deliverable}
                    <tr>
                        <td>{$deliverable.name}</td>
                        <td>{$deliverable.slug}</td>
                        <td>
                            <div class="dropdown">
                                <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$deliverable.deliverable_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Actions
                                </button>
                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$deliverable.deliverable_id}">
                                    <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editDeliverableModal" data-size="medium" data-options='{$deliverable|json_encode nofilter}'>
                                        <i class="fa fa-pencil-alt mr5"></i> Edit
                                    </a>
                                    <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="deliverable" data-id="{$deliverable.deliverable_id}">
                                        <i class="fa fa-trash mr5"></i> Delete
                                    </a>
                                </div>
                            </div>
                        </td>
                    </tr>
                {/foreach}
            </tbody>
        </table>

        {$pager nofilter}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No deliverables to show</strong></p>
    </div>
{/if}

<!-- Add Deliverable -->
<script id="addDeliverableModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addDeliverable" method="POST" autocomplete="off">
        <div class="modal-header">
            <h5 class="modal-title">Add Deliverable</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Name</label>
                <input name="name" type="text" class="form-control">
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Deliverable</button>
        </div>
    </form>
</script>
<!-- Add Deliverable -->

<!-- Edit Deliverable -->
<script id="editDeliverableModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editDeliverable" method="POST" autocomplete="off">
        <input type="hidden" name="deliverable_id" value="{literal}{{deliverable_id}}{/literal}">
        <div class="modal-header">
            <h5 class="modal-title">Edit Deliverable</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Title</label>
                <input name="name" type="text" class="form-control" value="{literal}{{name}}{/literal}">
            </div>

            <div class="form-group">
                <label class="control-label">Slug</label>
                <input name="slug" type="text" class="form-control" value="{literal}{{slug}}{/literal}">
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Deliverable -->