{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
<div class="card">
    <div class="card-header with-icon with-nav">
        <div class="mb20">  

            {if $controller == "disciplines"}
                <div class="pull-right flip">
                    <button type="button"  data-toggle="modal" data-url="#addDisciplineModal" data-size="medium" class="btn btn-success">
                        <i class="fa fa-plus mr5"></i> Add Discipline
                    </button>
                </div>
            {/if}

            {if $controller == "uploadTypes"}
                <div class="pull-right flip">
                    <button type="button"  data-toggle="modal" data-url="#addUploadTypeModal" data-size="small" class="btn btn-success">
                        <i class="fa fa-plus mr5"></i> Add Upload Type
                    </button>
                </div>
            {/if}

            {if $controller == "deliverables"}
                <div class="pull-right flip">
                    <button type="button"  data-toggle="modal" data-url="#addDeliverableModal" data-size="small" class="btn btn-success">
                        <i class="fa fa-plus mr5"></i> Add Deliverable
                    </button>
                </div>
            {/if}

            <i class="fa fa-cogs mr10"></i> 
            <strong>Preferences</strong>
            &rsaquo; <strong>General</strong>
        </div>
        <ul class="nav nav-tabs">

            <li {if $controller == "disciplines"}class="active"{/if}>
                <a href="{$base_uri}/preferences/general/disciplines" data-ajax="/preferences/general/disciplines"> 
                    {if $controller == "disciplines"}<strong class="pr5">Disciplines</strong>{else}Disciplines{/if} 
                </a>
            </li>

            <li {if $controller == "uploadTypes"}class="active"{/if}>
                <a href="{$base_uri}/preferences/general/upload-types" data-ajax="/preferences/general/upload-types"> 
                    {if $controller == "uploadTypes"}<strong class="pr5">Upload Types</strong>{else}Upload Types{/if} 
                </a>
            </li>

            {if $is_programming_enabled || $is_calculations_enabled}
                <li {if $controller == "deliverables"}class="active"{/if}>
                    <a href="{$base_uri}/preferences/general/deliverables" data-ajax="/preferences/general/deliverables"> 
                        {if $controller == "deliverables"}<strong class="pr5">Deliverables</strong>{else}Deliverables{/if} 
                    </a>
                </li>
            {/if}
        </ul>
    </div>

    <div class="card-body">
        {include file="dashboard/preferences/general/$controller.tpl"}
    </div>
</div>
{/block}