{if count($categories)}
    <div class="table-responsive">
        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Complex Category</th>
                    <th>Actions</th>
                </tr>
            </thead> 
            <tbody>
                {foreach $categories as $category}
                    <tr>
                        <td>
                            {$category.title} {if isset($categoryGroups[$category.discipline_id])}<span class="badge badge-info">Group</span>{/if}
                        </td>
                        <td>
                            {if $category.is_complex_assignment}
                                <span class="badge badge-success">Yes</span>
                            {else}
                                <span class="badge badge-danger">No</span>
                            {/if}
                        </td>
                        <td>
                            <div class="dropdown">
                                <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$category.discipline_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Actions
                                </button>
                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$category.discipline_id}">
                                    <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editCategoryModal" data-size="medium" data-options='{$category|json_encode nofilter}'>
                                        <i class="fa fa-pencil-alt mr5"></i> Edit
                                    </a>
                                    {if $category.discipline_id != '52'}
                                        <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="discipline" data-id="{$category.discipline_id}">
                                            <i class="fa fa-trash mr5"></i> Delete
                                        </a>
                                    {/if}
                                </div>
                            </div>
                        </td>
                    </tr>
                {/foreach}
            </tbody>
        </table>

        {$pager nofilter}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No categories to show</strong></p>
    </div>
{/if}

<!-- Add Category -->
<script id="addCategoryModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addCategory" method="POST" autocomplete="off">
        <div class="modal-header">
            <h5 class="modal-title">Add Category</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Title</label>
                <input name="title" type="text" class="form-control">
            </div>

            {if count($categoryGroups)}
                <div class="form-group">
                    <label class="control-label">Category Group</label>
                    <select class="form-control" name="discipline_group">
                        <option value="-1">None</option>
                        {foreach $categoryGroups as $categoryGroup}
                            <optgroup label="{$categoryGroup.title}">
                                {foreach $categoryGroup.disciplines as $category}
                                    <option value="{$category.discipline_id}">{$category.title}</option>
                                {/foreach}
                            </optgroup>
                        {/foreach}
                    </select>
                    <span class="help-block">
                        Categories have groups. You might have a Food & Nutrition discipline under Healthcare group. Totally optional.
                    </span>
                </div>
            {/if}

            <hr>

            <div class="form-table-row mb10"> 
                <div> 
                    <div class="form-control-label h5">Complex Category</div> 
                    <div class="form-text">Charge an extra 20% for the complexity of this category</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="is_complex_assignment"> 
                        <input type="checkbox" name="is_complex_assignment" id="is_complex_assignment"> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Category</button>
        </div>
    </form>
</script>
<!-- Add Category -->

<!-- Edit Category -->
<script id="editCategoryModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editCategory" method="POST" autocomplete="off">
        <input type="hidden" name="discipline_id" value="{literal}{{discipline_id}}{/literal}">
        <div class="modal-header">
            <h5 class="modal-title">Edit Category</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Title</label>
                <input name="title" type="text" class="form-control" value="{literal}{{title}}{/literal}">
            </div>

            {if count($categoryGroups)}
                <div class="form-group">
                    <label class="control-label">Category Group</label>
                    <select class="form-control" name="discipline_group">
                        <option value="-1">None</option>
                        {foreach $categoryGroups as $categoryGroup}
                            <optgroup label="{$categoryGroup.title}">
                                {foreach $categoryGroup.disciplines as $category}
                                    <option value="{$category.discipline_id}">{$category.title}</option>
                                {/foreach}
                            </optgroup>
                        {/foreach}
                    </select>
                    <span class="help-block">
                        Categories have groups. You might have a Food & Nutrition discipline under Healthcare group. Totally optional.
                    </span>
                </div>
            {/if}

            <hr>

            <div class="form-table-row mb0"> 
                <div> 
                    <div class="form-control-label h5">Complex Category</div> 
                    <div class="form-text">Charge an extra 20% for the complexity of this category</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="is_complex_assignment"> 
                        <input type="checkbox" name="is_complex_assignment" id="is_complex_assignment" {literal}{{#is_complex_assignment}}{/literal}checked=""{literal}{{/is_complex_assignment}}{/literal}> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Category -->