{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            <i class="fa fa-flag mr10"></i>
            <strong>Orders</strong>
            {if $sub_view != ""}
                &rsaquo; <strong>{$sub_view|capitalize} ({$total_orders})</strong>
            {/if}
        </div>

        <div class="card-body">
            
            {include file='dashboard/orders/_filters.orders.tpl'}

            {if count($orders) || count($urgentOrders)}

                {if count($urgentOrders)}
                    <div class="table-responsive">
                        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                            <thead>
                                <tr>
                                    <th>
                                        {if $user.is_admin || $user.is_sub_admin}
                                            <div class="custom-control custom-checkbox"> 
                                                <input type="checkbox" class="custom-control-input js_select-all" name="select_all" id="js_select-all"> 
                                                <label class="custom-control-label" for="js_select-all">Order ID</label>
                                            </div>
                                        {else}
                                            Order ID
                                        {/if}
                                    </th>
                                    <th>Topic Title</th>
                                    <th>Discipline</th>
                                    <th>Deadline</th>
                                    <th>Task</th>
                                    {if $show_client_cost}
                                        <th>COST</th>
                                    {/if}
                                    {if $user.is_admin || $user.is_sub_admin}
                                    <th>Actions</th>
                                    {/if}
                                </tr>
                            </thead>
                            <tbody>
                                {foreach $urgentOrders as $order}
                                    {include file='dashboard/orders/_order.available.tpl'}
                                {/foreach}
                            </tbody>
                        </table>
                    </div>
                {/if}
 
                {if count($orders)}
                    <div class="table-responsive">
                        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                            <thead>
                                <tr>
                                    <th>
                                        {if $user.is_admin || $user.is_sub_admin}
                                            <div class="custom-control custom-checkbox"> 
                                                <input type="checkbox" class="custom-control-input js_select-all" name="select_all" id="js_select-all"> 
                                                <label class="custom-control-label" for="js_select-all">Order ID</label>
                                            </div>
                                        {else}
                                            Order ID
                                        {/if}
                                    </th>
                                    <th>Topic Title</th>
                                    <th>Discipline</th>
                                    <th>Deadline</th>
                                    <th>Task</th>
                                    {if $show_client_cost}
                                        <th>COST</th>
                                    {/if}
                                    {if $user.is_admin || $user.is_sub_admin}
                                    <th>Actions</th>
                                    {/if}
                                </tr>
                            </thead>
                            <tbody>
                                {foreach $orders as $order}
                                    {include file='dashboard/orders/_order.available.tpl'}
                                {/foreach}
                            </tbody>
                        </table>
                        
                        {if $user.is_admin || $user.is_sub_admin}
                            <div class="mb-1">
                                <button class="btn btn-success btn-sm js_bulk-actions float-left">Bulk Actions</button>
                            </div>
                        {/if}
                    </div>
                {/if}

                {if count($orders) || count($urgentOrders)}
                    <div class="d-block">
                        {$pager nofilter}
                    </div>
                {/if}
            {else}
                <div class="text-center x-muted"> <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                    <p class="mb10"><strong>No orders to show</strong></p>
                </div>
            {/if}

        </div>
    </div>
{/block}
