{extends file='dashboard/layout.tpl'} 
 
{block name='content_wrapper'}
<div class="card">
    <div class="card-header with-icon">
        {if $user.is_admin || $user.is_sub_admin}
            <div class="pull-right flip">
                <a href="{$base_uri}/order/{$order.id}" class="btn btn-secondary">
                    <i class="fa fa-arrow-left fa-fw mr5"></i> Back to Order
                </a>
            </div>
        {/if}
        <i class="fa fa-shopping-basket mr10"></i>
        <strong>Orders</strong>
        &rsaquo; <strong>#{$order.id}</strong>
        &rsaquo; <strong>Edit</strong>
    </div>
 
    <form class="form-horizontal js_ajax-forms" id="orderForm" data-url="/order" method="POST" autocomplete="off">
        <div class="card-body">
            <input type="hidden" name="serviceType" value="{$order.serviceTypeId}"/>
            <input type="hidden" name="order_id" value="{$order.id}">

            {if $order.serviceTypeId == \Proxim\Order\Order::COMPLEX_ASSIGNMENT}
                {include file='dashboard/order/edit/academic.tpl'}
            {/if}

            {if $order.serviceTypeId == \Proxim\Order\Order::PROGRAMMING}
                {include file='dashboard/order/edit/programming.tpl'}
            {/if}

            {if $order.serviceTypeId == \Proxim\Order\Order::CALCULATIONS}
                {include file='dashboard/order/edit/calculations.tpl'}
            {/if}

            {if $order.serviceTypeId == \Proxim\Order\Order::ARTICLE_WRITING}
                {include file='dashboard/order/edit/article.tpl'}
            {/if}

            <div class="form-group form-row">
                <div class="col-md-9 offset-sm-2">
                    <!-- success -->
                    <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                    <!-- success -->

                    <!-- error -->
                    <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                    <!-- error -->
                </div>
            </div>
        </div>
        <div class="card-footer text-center">
            <button type="submit" class="btn btn-primary">Save Changes</button>
        </div>
    </form>
</div>
{/block}


{block name="custom_js"}
    <script type="text/javascript">
    $(function () { 
        var academicTariffs = {json_encode($academicTariffs) nofilter};
        var $form = $("#orderForm");
        var serviceTypeId, $disciplineId;

        $form.find('[name="changeDeadline"]').on('change',function(){
            if ($(this).is(':checked')) {
                $form.find('[deadline-combo]').removeClass('x-hidden');
            } else {
                $form.find('[deadline-combo]').addClass('x-hidden');
            }
        });

        if($form.find('[name="academicLevelId"]')) {
            var academicLevel = $("[name='academicLevelId'] :selected").val();
            renderTariffs(academicLevel);
        }   

        $form.find('[name="academicLevelId"]').change(function(e) {
            academicLevel = $("[name='academicLevelId'] :selected").val();
            renderTariffs(academicLevel);
        });

        $(document).on('change click input', $form.find('.js_calculate'), function(e) {
            calculate();
        });

        $('.js_custom-toggle').on('change',function(){
            var _this = $(this);
            var $value= _this.val();
            var $val = _this.data('val');
            var parent = $(this).closest('.form-group');

            if($value == $val) {
                parent.next('.form-group').removeClass('x-hidden');
            } else {
                parent.next('.form-group').addClass('x-hidden');
            }
        });

        function renderTariffs( academicLevel ) {
            var tariffControl = $("[data-tariff-control]");
            var tariffId = tariffControl.attr("tariff-id");
            tariffControl.empty();

            if ( academicLevel ) {
                var activeTariff = academicTariffs[academicLevel];
                $.each(activeTariff, function(i, tariff){
                    var selected = tariffId == tariff.id ? true : false;
                    tariffControl.append( $('<option>').text(tariff.name).attr('value', tariff.id).attr('data-hrs', tariff.hrs).attr('data-cpp', tariff.pricePerPage.value).prop('selected', selected ) );
                });
            }

            return true;
        }

        function calculate() {
            var availableWinbackCoupons = discount = null;
            var formStateForCalculator = {};
            serviceTypeId = parseInt($form.find('[name="serviceType"]:checked').val()) || parseInt($form.find('[name="serviceType"]').val());

            try {
                {if $order.serviceTypeId == 50}
                    var itemPrice = $form.find('[name="calculations[taskSizeId]"]:checked').data('price') || 0;
                    var priceModifier = $form.find('[name="calculations[tariffId]"] :selected').data('pricing') || 0;
                    $form.find('[name="calculations[priceModifier]"]').val(priceModifier);

                    var cost = normalizePrice(itemPrice * priceModifier);
                    $form.find("#orderPrice").text("$"+cost);

                {elseif $order.serviceTypeId == 51}
                    var itemPrice = $form.find('[name="programming[taskSizeId]"]:checked').data('price') || 0;
                    var priceModifier = $form.find('[name="programming[tariffId]"] :selected').data('pricing') || 0;
                    $form.find('[name="programming[priceModifier]"]').val(priceModifier);

                    var cost = normalizePrice(itemPrice * priceModifier);
                    $form.find("#orderPrice").text("$"+cost);
                        
                {elseif $order.serviceTypeId == 52}
                    var pricePerWord = $form.find('[name="article[tariffId]"] :selected').data('pricing') || 0;
                    var wordsQty = parseInt($form.find('[name="article[words]"]').val());
                    var writerCategoryPercent = $form.find('[name="article[writerCategory]"]:checked').data('percent') || 0;
                    
                    var cost = normalizePrice(pricePerWord * wordsQty);
                    var prefferedWriterPrice = normalizePrice(
                        (cost * writerCategoryPercent) / 100
                    );

                    var baseCost = normalizePrice(cost + prefferedWriterPrice);
                    $form.find("#orderPrice").text("$"+baseCost);
 
                {else}
                    formStateForCalculator = {
                        discount,
                        winbackCoupons: availableWinbackCoupons,
                        writerCategoryId: parseInt($form.find('[name="writerCategoryId"] :selected').val()) || null,
                        writerPercent: parseInt($form.find('[name="writerCategoryId"] :selected').data('percent')) || null,
                        complexAssignmentDiscipline: $form.find('[name="topicCatId"] :selected').data('complex') || 0,
                        pages: parseFloat($form.find('[name="pages"]').val()), 
                        slides: parseInt($form.find('[name="slides"]').val()),
                        charts: parseInt($form.find('[name="charts"]').val()),
                        excelSheets: parseInt($form.find('[name="excelSheets"]').val()),
                        tariffPricePerPage: {$order.tariffPricePerPage},
                        tariffHrs: {$order.tariffHrs},
                        spacing: $form.find('[name="spacing"]:checked').val() || false,
                        getSamplesOn: $form.find('[name="samplesNeeded"]:checked').val() || false,
                        getProgressiveDeliveryOn: $form.find('[name="progressiveDeliveryHidden"]:checked').val() || false,
                        getUsedSourcesOn: $form.find('[name="usedsources"]:checked').val() || false,
                        expertProofreading: $form.find('[name="expertProofreading"]:checked').val() || false
                    };

                    if( $form.find('[name="changeDeadline"]').is(':checked') ) {
                        formStateForCalculator.tariffPricePerPage = $form.find('[name="tariffId"] :selected').data('cpp') || 0;
                        formStateForCalculator.tariffHrs = $form.find('[name="tariffId"] :selected').data('hrs') || 0;
                    }
                    
                    if($form.find("#orderPrice").length) {
                        var cost = PROXIMCostCalculator.calculate(formStateForCalculator);
                        $form.find("#orderPrice").text("$"+cost.totalCost);
                    }
                {/if}
                
            } catch (e) {
                console.error(e);
            }
        }        
    });
    </script>
{/block}