<div class="card">
    <div class="card-header with-icon with-nav">
        <div class="mb20"> 
            <div class="pull-right flip">
                <a href="{$base_uri}/order/{$order.id}" data-ajax="/order/{$order.id}" class="btn btn-secondary">
                    <i class="fa fa-arrow-left fa-fw mr5"></i> Back to Order
                </a>
            </div>

            <i class="fa fa-shopping-basket mr10"></i>
            <strong>Orders</strong>
            &rsaquo; <strong>#{$order.id}</strong>
            &rsaquo; <strong>Bids &amp; Writers</strong>
        </div>

        <ul class="nav nav-tabs">
            <li {if $_get == "bids"}class="active"{/if}>
                <a href="{$base_uri}/order/{$order.id}/assign?get=bids" data-ajax="/order/{$order.id}/assign?get=bids"> 
                    {if $_get == "bids"}<strong class="pr5">Bids</strong>{else}Bids{/if}
                    {if count($bids) > 0}
                        <span class="label label-success ml5">{count($bids)}</span>
                    {/if}
                </a>
            </li>
            <li {if $_get == "writers"}class="active"{/if}> 
                <a href="{$base_uri}/order/{$order.id}/assign?get=writers" data-ajax="/order/{$order.id}/assign?get=writers">
                    {if $_get == "writers"}<strong class="pr5">Writers</strong>{else}Writers{/if}
                    {if count($writers) > 0}
                        <span class="label label-success ml5">{count($writers)}</span>
                    {/if}
                </a> 
            </li>

            {if $editor_account_enabled}
                <li {if $_get == "editors"}class="active"{/if}> 
                    <a href="{$base_uri}/order/{$order.id}/assign?get=editors" data-ajax="/order/{$order.id}/assign?get=editors">
                        {if $_get == "editors"}<strong class="pr5">Editors</strong>{else}Editors{/if}
                    </a> 
                </li>
            {/if}

            {if $order_manager_enabled}
                <li {if $_get == "ordermanagers"}class="active"{/if}> 
                    <a href="{$base_uri}/order/{$order.id}/assign?get=ordermanagers" data-ajax="/order/{$order.id}/assign?get=ordermanagers">
                        {if $_get == "ordermanagers"}<strong class="pr5">Order Managers</strong>{else}Order Managers{/if}
                    </a> 
                </li>
            {/if}
        </ul>

    </div>

    {if $_get == "writers"}

        <div class="card-body">

            <form class="row mb10" method="GET">
                <div class="col-md-7">
                    <input type="hidden" name="get" value="writers"/>
                    <input type="text" name="query" autocomplete="off" class="form-control input-sm" value="{$query}" placeholder="Search writer ID, name or email" />
                </div>
                <div class="col-md-2">
                    <button class="btn btn-primary">Search</button>
                </div>
            </form> 

            {if $total_writers > 0}
                <ul class="row">
                    {foreach $writers as $writer}
                        <li class="col-sm-12 col-md-6">
                            {include file='dashboard/order/__assign.writer.tpl' _writer=$writer}
                        </li>
                    {/foreach}
                </ul>

                {$pager nofilter}
            {else}
                <div class="text-center x-muted"> 
                    <i class="fa fa-users fa-4x"></i>
                    <p class="mb10"><strong>No writers found</strong></p>
                </div>
            {/if}
        </div>

    {elseif $_get == "bids"}
        <div class="card-body">
            {if $total_bids > 0}
                <ul class="row">
                    {foreach $bids as $bid}
                        <li class="col-sm-12 col-md-6">
                            {include file='dashboard/order/__assign.writer.tpl' _writer=$bid}
                        </li>
                    {/foreach}
                </ul>

                {$pager nofilter}
            {else}
                <div class="text-center x-muted"> 
                    <i class="fa fa-users fa-4x"></i>
                    <p class="mb10"><strong>No bids found</strong></p>
                </div>
            {/if}
        </div>

    {elseif $_get == "editors"}

        <div class="card-body">

            <form class="row mb10" method="GET">
                <div class="col-md-7">
                    <input type="hidden" name="get" value="editors"/>
                    <input type="text" name="query" autocomplete="off" class="form-control input-sm" value="{$query}" placeholder="Search editor ID, name or email" />
                </div>
                <div class="col-md-2">
                    <button class="btn btn-primary">Search</button>
                </div>
            </form> 

            {if $total_editors > 0}
                <ul class="row">
                    {foreach $editors as $editor}
                        <li class="col-sm-12 col-md-6">
                            {include file='dashboard/order/__assign.editor.tpl' _editor=$editor}
                        </li>
                    {/foreach}
                </ul>

                {$pager nofilter}
            
            {else}
                <div class="text-center x-muted"> 
                    <i class="fa fa-users fa-4x"></i>
                    <p class="mb10"><strong>No editors found</strong></p>
                </div>
            {/if}
        </div>

    {elseif $_get == "ordermanagers"}

        <div class="card-body">

            <form class="row mb10" method="GET">
                <div class="col-md-7">
                    <input type="hidden" name="get" value="ordermanagers"/>
                    <input type="text" name="query" autocomplete="off" class="form-control input-sm" value="{$query}" placeholder="Search user ID, name or email" />
                </div>
                <div class="col-md-2">
                    <button class="btn btn-primary">Search</button>
                </div>
            </form> 

            {if $total_ordermanagers > 0}
                <ul class="row">
                    {foreach $ordermanagers as $ordermanager}
                        <li class="col-sm-12 col-md-6">
                            {include file='dashboard/order/__assign.ordermanager.tpl' _ordermanager=$ordermanager}
                        </li>
                    {/foreach}
                </ul>

                {$pager nofilter}
            
            {else}
                <div class="text-center x-muted"> 
                    <i class="fa fa-users fa-4x"></i>
                    <p class="mb10"><strong>No order managers found</strong></p>
                </div>
            {/if}
        </div>
    {/if}

</div>