{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon with-nav">
            <div class="mb20">
                <i class="fa fa-globe mr10"></i>
                <strong>My Sites</strong>
                &rsaquo; <strong>{$site.name}</strong>
                &rsaquo; <strong>Preferences</strong>
                
                <div class="pull-right">
                    <a href="{$base_uri}/my-sites/{$site.id}" data-ajax="/my-sites/{$site.id}" class="btn btn-default">
                        <i class="fa fa-arrow-left"></i> Back to Site
                    </a>

                    {if $tab == "deadlines"}
                        <button type="button" data-toggle="modal" data-url="#addDeadlineModal" data-size="medium" class="btn btn-primary ml5">
                            <i class="fa fa-plus"></i> Add new Deadline
                        </button>
                    {/if}
                    
                </div>
            </div>

            <!-- tabs nav -->
            <ul class="nav nav-tabs admin">
                <li {if $tab == "features"}class="active"{/if}>
                    <a href="{$base_uri}/my-sites/{$site.id}/preferences?tab=features" data-ajax="/my-sites/{$site.id}/preferences?tab=features"> 
                        {if $tab == "features"}<strong class="pr5">Form Features</strong>{else}Form Features{/if} 
                    </a>
                </li>

                <li {if $tab == "add-services"}class="active"{/if}>
                    <a href="{$base_uri}/my-sites/{$site.id}/preferences?tab=add-services" data-ajax="/my-sites/{$site.id}/preferences?tab=add-services"> 
                        {if $tab == "add-services"}<strong class="pr5">Additional services</strong>{else}Additional services{/if} 
                    </a>
                </li>
            </ul>
            <!-- tabs nav -->
        </div> 

        <div class="card-body row">
            {if $tab == "features"}
                <!-- Features -->
                <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/sites?do=features_settings">
                    <input type="hidden" name="site_id" value="{$site.id}"/>

                    <div class="heading-small mb20">Service Types</div>
                    <div class="form-table-row"> 
                        <div class="icon">
                            {include file='__svg_icons.tpl' icon="academic" class="mr5" width="40px" height="40px"}
                        </div>
                        <div> 
                            <div class="form-control-label h5">Academic Writing</div> 
                            <div class="form-text">Enable Custom papers</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="order_academic_enabled"> 
                                <input type="checkbox" name="order_academic_enabled" id="order_academic_enabled" {if $formValues.ACADEMIC_WRITING_ENABLED}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    {if $is_programming_enabled}
                        <div class="form-table-row"> 
                            <div class="icon">
                                {include file='__svg_icons.tpl' icon="programming" class="mr5" width="40px" height="40px"}
                            </div>
                            <div> 
                                <div class="form-control-label h5">Programming</div> 
                                <div class="form-text">Enable to allow customers to order tech assignments</div> 
                            </div> 
                            <div class="text-right"> 
                                <label class="switch" for="order_programming_enabled"> 
                                    <input type="checkbox" name="order_programming_enabled" id="order_programming_enabled" {if $formValues.PROGRAMMING_ENABLED}checked=""{/if}> 
                                    <span class="slider round"></span> 
                                </label> 
                            </div> 
                        </div>
                    {/if}

                    {if $is_calculations_enabled}
                        <div class="form-table-row"> 
                            <div class="icon">
                                {include file='__svg_icons.tpl' icon="calculations" class="mr5" width="40px" height="40px"}
                            </div>
                            <div> 
                                <div class="form-control-label h5">Calculations</div> 
                                <div class="form-text">Enable to allow customers to order calculations problems</div> 
                            </div> 
                            <div class="text-right"> 
                                <label class="switch" for="order_calculations_enabled"> 
                                    <input type="checkbox" name="order_calculations_enabled" id="order_calculations_enabled" {if $formValues.CALCULATIONS_ENABLED}checked=""{/if}> 
                                    <span class="slider round"></span> 
                                </label> 
                            </div> 
                        </div>
                    {/if}

                    {if $is_articlewriting_enabled}
                        <div class="form-table-row"> 
                            <div class="icon">
                                {include file='__svg_icons.tpl' icon="article" class="mr5" width="40px" height="40px"}
                            </div>
                            <div> 
                                <div class="form-control-label h5">Article Writing</div> 
                                <div class="form-text">Enable to allow customers to order custom articles</div> 
                            </div> 
                            <div class="text-right"> 
                                <label class="switch" for="order_article_enabled"> 
                                    <input type="checkbox" name="order_article_enabled" id="order_article_enabled" {if $formValues.ARTICLE_WRITING_ENABLED}checked=""{/if}> 
                                    <span class="slider round"></span> 
                                </label> 
                            </div> 
                        </div>
                    {/if}

                    <div class="divider"></div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Order Form Coupons</div> 
                            <div class="form-text">Show available coupons on the order form</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="order_form_coupons"> 
                                <input type="checkbox" name="order_form_coupons" id="order_form_coupons" {if $formValues.ORDER_FORM_COUPONS}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Free Inquiry</div> 
                            <div class="form-text">Allow customers to make order inquiries</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="order_inquiry_enabled"> 
                                <input type="checkbox" name="order_inquiry_enabled" id="order_inquiry_enabled" {if $formValues.INQUIRY_ENABLED}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Lifetime Discounts</div> 
                            <div class="form-text">Give customers lifetime discounts</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="discounts_enabled"> 
                                <input type="checkbox" name="discounts_enabled" id="discounts_enabled" {if $formValues.DISCOUNTS_ENABLED}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Refund Requests</div> 
                            <div class="form-text">Enable or disable to allow your customers to request refunds on your website </div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="request_refund_enabled"> 
                                <input type="checkbox" name="request_refund_enabled" id="request_refund_enabled" {if $formValues.REQUEST_REFUND_ALLOWED}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-group">
                        <!-- success -->
                        <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                        <!-- success -->

                        <!-- error -->
                        <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                        <!-- error -->

                        <button type="submit" class="btn btn-primary">Save Changes</button>
                    </div>

                </form>
                <!-- Features -->
            {elseif $tab == "add-services"}
                <!-- Features -->
                <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/sites?do=add_services_settings">
                    <input type="hidden" name="site_id" value="{$site.id}"/>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Expert Proofreading</div> 
                            <div class="form-text">Expert Proofreading (25%) - Get your paper checked by an expert proofreader: no grammatical and spelling mistakes, a perfect match with your requirements, and correspondence with the chosen academic level.</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="expert_proofreading_enabled"> 
                                <input type="checkbox" name="expert_proofreading_enabled" id="expert_proofreading_enabled" {if $formValues.EXPERT_PROOFREADING_ENABLED}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">VIP Support</div> 
                            <div class="form-text">VIP Support ($9.99) - Personal 24/7 VIP manager responsible for tracking your order until final delivery, alongside personalized communication via call and text.</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="vip_support_enabled"> 
                                <input type="checkbox" name="vip_support_enabled" id="vip_support_enabled" {if $formValues.VIP_SUPPORT_ENABLED}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Plagiarism Report</div> 
                            <div class="form-text">Plagiarism Report ($9.99) - All papers are checked for plagiarims but if you'd like an official report alongside your paper please choose this option.</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="plagiarism_report_enabled"> 
                                <input type="checkbox" name="plagiarism_report_enabled" id="plagiarism_report_enabled" {if $formValues.PLAGIARISM_REPORT_ENABLED}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Draft/Outline</div> 
                            <div class="form-text">Draft/Outline (25%) - We will prepare a draft outlining structure and key points to be discussd in your paper and send send it before the final paper is complete.</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="draft_outline_enabled"> 
                                <input type="checkbox" name="draft_outline_enabled" id="draft_outline_enabled" {if $formValues.DRAFT_OUTLINE_ENABLED}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Writer Samples</div> 
                            <div class="form-text">Writer Samples ($5) - Review 3 samples of work previously completed by the writer assigned to your order.</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="writer_samples_enabled"> 
                                <input type="checkbox" name="writer_samples_enabled" id="writer_samples_enabled" {if $formValues.WRITER_SAMPLES_ENABLED}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Progressive Delivery</div> 
                            <div class="form-text">Progressive Delivery (10%) - Get your paper delivered step by step. For more information, please check our Progressive Delivery web page. Available for orders with a deadline of 5 days and longer, and with the value of $200 or more.</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="p_delivery_enabled"> 
                                <input type="checkbox" name="p_delivery_enabled" id="p_delivery_enabled" {if $formValues.PROGRESSIVE_DELIVERY_ENABLED}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Copy of Sources</div> 
                            <div class="form-text">Copy Of Sources (10%) - Get excerpts of the articles and e-books or the links to these excerpts cited in the paper.</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="copy_of_sources_enabled"> 
                                <input type="checkbox" name="copy_of_sources_enabled" id="copy_of_sources_enabled" {if $formValues.COPY_OF_SOURCES_ENABLED}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-group form-row">
                        <!-- success -->
                        <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                        <!-- success -->

                        <!-- error -->
                        <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                        <!-- error -->

                        <button type="submit" class="btn btn-primary">Save Changes</button>
                    </div>

                </form>
                <!-- Features -->
            {/if}
        </div>
    </div>
{/block}