{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon with-nav">
            <div class="mb20">
                <i class="fa fa-globe mr10"></i>
                <strong>My Sites</strong>
                &rsaquo; <strong>{$site.name}</strong>
                &rsaquo; <strong>Deadlines</strong>
                
                <div class="pull-right">
                    <a href="{$base_uri}/my-sites/{$site.id}" data-ajax="/my-sites/{$site.id}" class="btn btn-default">
                        <i class="fa fa-arrow-left"></i> Back to Site
                    </a>
                </div>
            </div>

            <!-- tabs nav -->
            <ul class="nav nav-tabs admin">
                <li {if $tab == "academic"}class="active"{/if}>
                    <a href="{$base_uri}/my-sites/{$site.id}/deadlines?tab=academic" data-ajax="/my-sites/{$site.id}/deadlines?tab=academic"> 
                        {if $tab == "academic"}<strong class="pr5">Academic Writing</strong>{else}Academic Writing{/if} 
                    </a>
                </li>

                {if $is_programming_enabled}
                    <li {if $tab == "programming"}class="active"{/if}>
                        <a href="{$base_uri}/my-sites/{$site.id}/deadlines?tab=programming" data-ajax="/my-sites/{$site.id}/deadlines?tab=programming"> 
                            {if $tab == "programming"}<strong class="pr5">Programming</strong>{else}Programming{/if} 
                        </a>
                    </li>
                {/if}

                {if $is_calculations_enabled}
                    <li {if $tab == "calculations"}class="active"{/if}>
                        <a href="{$base_uri}/my-sites/{$site.id}/deadlines?tab=calculations" data-ajax="/my-sites/{$site.id}/deadlines?tab=calculations"> 
                            {if $tab == "calculations"}<strong class="pr5">Calculations</strong>{else}Calculations{/if} 
                        </a>
                    </li>
                {/if}

                {if $is_articlewriting_enabled}
                    <li {if $tab == "articles"}class="active"{/if}>
                        <a href="{$base_uri}/my-sites/{$site.id}/deadlines?tab=articles" data-ajax="/my-sites/{$site.id}/deadlines?tab=articles"> 
                            {if $tab == "article"}<strong class="pr5">Article Writing</strong>{else}Article Writing{/if} 
                        </a>
                    </li>
                {/if}
            </ul>
            <!-- tabs nav -->
        </div> 

        <div class="card-body">
            {include file="dashboard/my-sites/deadlines.$tab.tpl"}
        </div>
    </div>
{/block}