<div class="clearfix mb20">
    <div class="pull-right">
        <button type="button" data-toggle="modal" data-url="#addDeadlineModal" data-size="medium" class="btn btn-primary hidden-sm">
            <i class="fa fa-plus"></i> Add new Deadline
        </button>
    </div>
</div>

{if count($deadlines)}
    <div class="table-responsive">
        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Hours Customer</th>
                    <th>Hours Writer</th>
                    <th>Price Modifier</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                {foreach $deadlines as $deadline}
                    <tr>
                        <td>{$deadline.name}</td>
                        <td>{pluralize('Hour', $deadline.hrs)}</td>
                        <td>{pluralize('Hour', $deadline.hrs_writer)}</td>
                        <td>
                            <strong class="text-success">{$deadline.price_modifier.amountFormatted}</strong>
                        </td>
                        <td>
                            <div class="dropdown">
                                <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$deadline.id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Actions
                                </button>
                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$deadline.id}">
                                    <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editDeadlineModal" data-size="medium" data-options='{$deadline|json_encode nofilter}'>
                                        <i class="fa fa-pencil-alt mr5"></i> Edit
                                    </a>
                                    <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="deadline" data-id="{$deadline.id}">
                                        <i class="fa fa-trash-alt mr5"></i> Delete
                                    </a>
                                </div>
                            </div>
                        </td>
                    </tr>
                {/foreach}
            </tbody>
        </table>
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No deadlines to show</strong></p>
    </div>
{/if}

<!-- Add Deadline -->
<script id="addDeadlineModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addCalculationsDeadline" method="POST" autocomplete="off">
        <input type="hidden" name="site_id" value="{$site.id}">
        <div class="modal-header">
            <h5 class="modal-title">Add Deadline</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-row">
                <div class="form-group col-md-6">
                    <label class="control-label">Name</label>
                    <input name="name" type="text" class="form-control">
                    <span class="help-block">Deadline name e.g. 12 Hours</span>
                </div>

                <div class="form-group col-md-6">
                    <label class="control-label text-left">Price Modifier</label>
                    <div class="input-group">
                        <div class="input-group-prepend"> 
                            <span class="input-group-text">$</span> 
                        </div>
                        <input name="price_modifier" type="text" class="form-control force-integer">
                    </div>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group col-md-6">
                    <label class="control-label">Hours Customer</label>
                    <input name="hrs_customer" type="text" class="form-control force-integer">
                    <span class="help-block">i.e If the deadline name is 12 Hours use <strong>12</strong> as Hours Customer</span>
                </div>

                <div class="form-group col-md-6">
                    <label class="control-label">Hours Writer</label>
                    <input name="hrs_writer" type="text" class="form-control force-integer">
                    <span class="help-block">The number of hours the writer will get to complete the order</span>
                </div>
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Deadline</button>
        </div>
    </form>
</script>
<!-- Add Deadline -->

<!-- Edit Deadline -->
<script id="editDeadlineModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editCalculationsDeadline" method="POST" autocomplete="off">
        <input type="hidden" name="deadline_id" value="{literal}{{id}}{/literal}">
        <div class="modal-header">
            <h5 class="modal-title">Edit Deadline</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-row">
                <div class="form-group col-md-6">
                    <label class="control-label">Name</label>
                    <input name="name" type="text" class="form-control" value="{literal}{{name}}{/literal}">
                    <span class="help-block">Deadline name e.g. 12 Hours</span>
                </div>

                <div class="form-group col-md-6">
                    <label class="control-label text-left">Price Modifier</label>
                    <div class="input-group">
                        <div class="input-group-prepend"> 
                            <span class="input-group-text">$</span> 
                        </div>
                        <input name="price_modifier" type="text" class="form-control force-integer" value="{literal}{{price_modifier.value}}{/literal}">
                    </div>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group col-md-6">
                    <label class="control-label">Hours Customer</label>
                    <input name="hrs_customer" type="text" class="form-control force-integer" value="{literal}{{hrs}}{/literal}">
                    <span class="help-block">i.e If the deadline name is 12 Hours use <strong>12</strong> as Hours Customer</span>
                </div>

                <div class="form-group col-md-6">
                    <label class="control-label">Hours Writer</label>
                    <input name="hrs_writer" type="text" class="form-control force-integer" value="{literal}{{hrs_writer}}{/literal}">
                    <span class="help-block">The number of hours the writer will get to complete the order</span>
                </div>
            </div>
        
            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Deadline -->