<form class="mb20" action="/my-sites/{$site.id}/deadlines" method="get">
    {if $tab}
        <input type="hidden" name="tab" value="{$tab}">
    {/if}
    <div class="form-group">
        <label class="form-label">Academic Level</label>
        <div class="form-inline">
            <div class="input-group"> 
                <select class="form-control" name="academicLevel">
                    {foreach $academic_levels as $academic_level}
                        <option value="{$academic_level.id}" {if $academic_level_selected == $academic_level.id}selected=""{/if}>{$academic_level.title}</option>
                    {/foreach}
                </select>
                <div class="input-group-append"> 
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search mr5"></i> Filter
                    </button> 
                </div>
            </div>
            <button type="button" data-toggle="modal" data-url="#addDeadlineModal" data-size="medium" class="btn btn-primary hidden-sm mlauto">
                <i class="fa fa-plus"></i> Add new Deadline
            </button>
        </div>
    </div>
</form>

{if count($deadlines)}
    <div class="table-responsive">
        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Hours Customer</th>
                    <th>Hours Writer</th>
                    <th>Minimum Pages</th>
                    <th>Price Per Page</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                {foreach $deadlines as $deadline}
                    <tr>
                        <td>{$deadline.name}</td>
                        <td>{pluralize('Hour', $deadline.hrs)}</td>
                        <td>{pluralize('Hour', $deadline.hrs_writer)}</td>
                        <td>{pluralize('Page', $deadline.min_pages)}</td>
                        <td>
                            <strong class="text-success">{$deadline.price_per_page.amountFormatted}</strong>
                        </td>
                        <td>
                            <div class="dropdown">
                                <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$deadline.id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Actions
                                </button>
                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$deadline.id}">
                                    <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editDeadlineModal" data-size="medium" data-options='{$deadline|json_encode nofilter}'>
                                        <i class="fa fa-pencil-alt mr5"></i> Edit
                                    </a>
                                    <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="deadline" data-id="{$deadline.id}">
                                        <i class="fa fa-trash-alt mr5"></i> Delete
                                    </a>
                                </div>
                            </div>
                        </td>
                    </tr>
                {/foreach}
            </tbody>
        </table>
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No deadlines to show</strong></p>
    </div>
{/if}

<!-- Add Deadline -->
<script id="addDeadlineModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addAcademicDeadline" method="POST" autocomplete="off">
        <input type="hidden" name="site_id" value="{$site.id}">
        <div class="modal-header">
            <h5 class="modal-title">Add Deadline</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-row">
                <div class="form-group col-md-6">
                    <label class="control-label">Academic Level</label>
                    <select class="form-control" name="academic_level_id">
                        {foreach $academic_levels as $academic_level}
                            <option value="{$academic_level.id}">{$academic_level.title}</option>
                        {/foreach}
                    </select>
                </div>

                <div class="form-group col-md-6">
                    <label class="control-label">Name</label>
                    <input name="name" type="text" class="form-control" placeholder="e.g. 12 Hours">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group col-md-6">
                    <label class="control-label">Hours Customer</label>
                    <input name="hrs_customer" type="text" class="form-control force-integer">
                    <span class="help-block">i.e If the deadline name is 12 Hours use <strong>12</strong> as Hours Customer</span>
                </div>

                <div class="form-group col-md-6">
                    <label class="control-label">Hours Writer</label>
                    <input name="hrs_writer" type="text" class="form-control force-integer">
                    <span class="help-block">The number of hours the writer will get to complete the order</span>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group col-md-6">
                    <label class="control-label text-left">Price per Page</label>
                        <div class="input-group">
                        <div class="input-group-prepend"> 
                            <span class="input-group-text">$</span> 
                        </div>
                        <input name="price_per_page" type="text" class="form-control force-integer">
                    </div>
                    <span class="help-block">The customer's Price per Page</span>
                </div>
                <div class="form-group col-md-6">
                    <label class="control-label">Minimum Pages</label>
                    <input name="min_pages" type="text" class="form-control force-integer" value="0">
                    <span class="help-block">The minimum Pages needed to show this deadline. i.e You can hide a 1 Month deadline for orders with less than 5 page.</span>
                </div>
            </div>
        
            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Deadline</button>
        </div>
    </form>
</script>
<!-- Add Deadline -->

<!-- Edit Deadline -->
<script id="editDeadlineModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editAcademicDeadline" method="POST" autocomplete="off">
        <input type="hidden" name="deadline_id" value="{literal}{{id}}{/literal}">
        <div class="modal-header">
            <h5 class="modal-title">Edit Deadline</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Name</label>
                <input name="name" type="text" class="form-control" value="{literal}{{name}}{/literal}">
                <span class="help-block">Deadline name e.g. 12 Hours</span>
            </div>

            <div class="form-row">
                <div class="form-group col-md-6">
                    <label class="control-label">Hours Customer</label>
                    <input name="hrs_customer" type="text" class="form-control force-integer" value="{literal}{{hrs}}{/literal}">
                    <span class="help-block">i.e If the deadline name is 12 Hours use <strong>12</strong> as Hours Customer</span>
                </div>

                <div class="form-group col-md-6">
                    <label class="control-label">Hours Writer</label>
                    <input name="hrs_writer" type="text" class="form-control force-integer" value="{literal}{{hrs_writer}}{/literal}">
                    <span class="help-block">The number of hours the writer will get to complete the order</span>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group col-md-6">
                    <label class="control-label text-left">Price per Page</label>
                    <div class="input-group">
                        <div class="input-group-prepend"> 
                            <span class="input-group-text">$</span> 
                        </div>
                        <input name="price_per_page" type="text" class="form-control force-integer" value="{literal}{{price_per_page.value}}{/literal}">
                    </div>
                    <span class="help-block">The customer's Price per Page</span>
                </div>

                <div class="form-group col-md-6">
                    <label class="control-label">Minimum Pages</label>
                    <input name="min_pages" type="text" class="form-control force-integer" value="{literal}{{min_pages}}{/literal}">
                    <span class="help-block">The minimum Pages needed to show this deadline. i.e You can hide a 1 Month deadline for orders with less than 5 page.</span>
                </div>
            </div>
        
            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Deadline -->