{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon with-nav">
            {if $sub_view == "catalogue"}
                <div class="pull-right flip">
                    <a class="btn btn-secondary mr10" href="{$base_uri}/modules/catalogue?refresh" data-ajax="/modules/catalogue?refresh"> 
                        <i class="fa fa-sync mr5"></i> Refresh
                    </a>
                    <button data-toggle="modal" data-url="#modalUploadPlugin" type="button" class="btn btn-success">
                        <i class="fa fa-plus mr5"></i> Upload Addon
                    </button>
                </div>
            {/if}

            <div class="mb20"> 
                <i class="fa fa-plug mr10"></i> <strong>Addons</strong> 
            </div>
            <ul class="nav nav-tabs">
                <li {if $sub_view == "catalogue"}class="active"{/if}>
                    <a href="{$base_uri}/modules/catalogue" data-ajax="/modules/catalogue"> 
                        {if $sub_view == "catalogue"}<strong class="pr5">Catalogue</strong>{else}Catalogue{/if} 
                    </a>
                </li>

                <li {if $sub_view == "installed"}class="active"{/if}>
                    <a href="{$base_uri}/modules/installed" data-ajax="/modules/installed"> 
                        {if $sub_view == "installed"}<strong class="pr5">Installed</strong>{else}Installed{/if} 
                    </a>
                </li>

            </ul>
        </div>

        {if $sub_view == "catalogue"}

            <div class="card-body">  

                {if count($modules_list)} 
                    <div class="row"> 
                        {foreach $modules_list as $module}
                            <div class="col-md-6 mb10">
                                <div class="card">
                                    <div class="card-body pt10 pl10 pb10 pr10">
                                        <div class="row align-items-center">
                                            <div class="col-md-3">
                                                <div class="card-img module_image" style="background-image: url({$module->logo});"></div>
                                            </div>
                                            <div class="col-md-9">
                                                <h4 class="card-title mt0 pt0 mb5">{$module->displayName}</h4>
                                                <p class="card-text">{$module->description}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer clearfix">
                                        {if $module->not_on_disk}
                                            {if isset($module->price)}
                                                <a href="{$module->buylink}" class="btn btn-sm btn-success pull-right">Buy {formatPrice($module->price)}</a>
                                            {else}
                                                <button data-module="{$module->name}" class="btn btn-sm btn-success pull-right js_download-module">Install</button>
                                            {/if}
                                        {else}
                                            {if !$module->installed}
                                                {if isset($module->price)}
                                                    <a href="{$module->buylink}" class="btn btn-sm btn-primary">Buy {formatPrice($module->price)}</a>
                                                    <button data-options='{literal}{{/literal}"module_name":"{$module->name}"{literal}}{/literal}' data-toggle="modal" data-url="#activateModule" data-title="Activate Module" class="btn btn-sm btn-success pull-right js_activate-module">Activate</button>
                                                {else}
                                                    <button data-module="{$module->name}" data-title="{$module->displayName}" class="btn btn-sm btn-success pull-right js_install-module">Install</button>
                                                {/if}
                                            {else}
                                                <button data-module="{$module->name}" class="btn btn-sm btn-secondary pull-right js_uninstall-module">Uninstall</button>
                                            {/if}
                                        {/if}
                                        
                                    </div>
                                </div>
                            </div>
                        {/foreach}
                    </div>
                {else}
                    <div class="text-center x-muted"> 
                        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                        <p class="mb10"><strong>No modules to show</strong></p>
                    </div>
                {/if}

            </div>

        {elseif $sub_view == "installed"}

            <div class="card-body"> 

                {if count($modules_list)} 
                    <div class="row"> 
                        {foreach $modules_list as $activeModule}
                            <div class="col-md-6 mb10">
                                <div class="card">
                                    <div class="card-body pt10 pl10 pb10 pr10">
                                        <div class="row align-items-center">
                                            <div class="col-md-3">
                                                <div class="card-img module_image" style="background-image: url({$activeModule->logo});"></div>
                                            </div>
                                            <div class="col-md-9">
                                                <h4 class="card-title mt0 pt0 mb5">{$activeModule->displayName}</h4>
                                                <p class="card-text">{$activeModule->description}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer clearfix">
                                        {if $activeModule->configure}
                                            <a href="{$base_uri}/{$activeModule->name}/configure" data-ajax="/{$activeModule->name}/configure" class="btn btn-sm btn-success">Configure</a>
                                        {/if}

                                        {if $activeModule->installed}
                                            <button data-module="{$activeModule->name}" class="btn btn-sm btn-secondary pull-right js_uninstall-module">Uninstall</button>
                                        {elseif $activeModule->installed}
                                        {else}
                                            <button data-module="{$activeModule->name}" class="btn btn-sm btn-success pull-right js_install-module">Install</button>
                                        {/if}
                                    </div>
                                </div>
                            </div>
                        {/foreach}
                    </div>
                {else}
                    <div class="text-center x-muted"> 
                        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                        <p class="mb10"><strong>No modules to show</strong></p>
                    </div>
                {/if}

            </div>

        {/if}
    </div>
</div>
{/block}