{if $ajax_page}
    <meta name="pagetitle" data-content="{$page_title}">
	{include file='dashboard/layout.body.tpl'}
{else}
	<!doctype html>
	<html lang="en-US">
		<head>
			{block name='head'}
				{include file='_partials/head.tpl'}
			{/block}
		</head>

		<body class="{$body_classes|classnames} {if $theme_mode_night}night-mode{/if}">
			<div class="main-wrapper">

				{block name='header'}
					{include file='_partials/header.tpl'}
				{/block}

				{include file='dashboard/layout.body.tpl'}

			</div>

			<div class="barloading"></div>
		</body>

		{if $user.logged}
			<!-- Notification -->
			<audio class="js_audio" id="notification_sound" preload="auto">
				<source src="{$base_uri}/static/sounds/notification.mp3" type="audio/mpeg">
			</audio>
			<!-- Notification -->
			<!-- Chat -->
			<audio class="js_audio" id="chat_sound" preload="auto">
				<source src="{$base_uri}/static/sounds/chat.mp3" type="audio/mpeg">
			</audio>
			<!-- Chat -->
		{/if}

		{include file="_partials/_js_files.tpl"}

		{literal}
		<script type="text/javascript">
			$(function() {

				$(document).on('click', 'a[data-ajax]', function(e) {
					e.preventDefault();
					var _this = $(this);

					startLoadingBar();
					var pageContainer = $('.page-container');
					var url = $(this).attr('data-ajax');
					var originalURL = `${base_uri+url}`;
					url = new URL(originalURL);
					url.searchParams.set('ajaxpage', 1);

					$.get(url, function (data) {
						if(_this.parents().hasClass('metismenu')) {
							$('.offcanvas').removeClass('active');
						}
						//$(data).filter('.container script').each(function (index, element) { 
						//	eval(element.innerHTML)
						//}); 

						var htmlPage = $(data).filter('.page-container').html();
						pageContainer.html(htmlPage);
						$('[role=tooltip]').tooltip('dispose');
						initialize();

						if(typeof initialize_modal === "function") {
							initialize_modal();
						}

						window.history.pushState({state:'new'},'', originalURL);
						window.onpopstate = function(event) {
							$(window).unbind('popstate');
							window.location.href = document.location;
						};

						document.title = $(data).filter('[name="pagetitle"]').data('content');
						$("html, body").animate({ scrollTop: 0 }, 150);
						stopLoadingBar();
					});

				});
			}); 
		</script>
		{/literal}

	</html>
{/if}