{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            <i class="fa fa-comments mr10"></i> 
            <strong>Feedback</strong> 
            {if $sub_view == "employee_feedback"} &rsaquo; <strong>Employee</strong> &rsaquo; <strong>{$employee_name}</strong>{/if}
        </div>

        {if $sub_view == "feedback" || $sub_view == "employee_feedback"}

            <div class="card-body">
                <div class="rating mb20">
                    <div class="row">
                        <div class="col-md-6">
                            <span class="heading">Customer Rating</span>

                            <div class="Rating Rating--large Rating--labeled" data-star_rating="{$insights['average_customer_rating']}">
                                <span class="Rating-total">
                                    <span class="Rating-progress"></span>
                                </span>
                            </div>
                            <p>{$insights['average_customer_rating']} average based on {$insights['total_customer_reviews']} reviews.</p>
                        </div>
                        <div class="col-md-6">
                            <span class="heading">Editor Rating</span>

                            <div class="Rating Rating--large Rating--labeled" data-star_rating="{$insights['average_editor_rating']}">
                                <span class="Rating-total">
                                    <span class="Rating-progress"></span>
                                </span>
                            </div>
                            <p>{$insights['average_editor_rating']} average based on {$insights['total_editor_reviews']} reviews.</p>
                        </div>
                    </div>
                    
                    <hr style="border: 3px solid #f1f1f1;" />
                    
                    <div class="rating-row">
                        {foreach range(1,5) as $i}
                            <div class="side">
                                <div>{$i} star</div>
                            </div>
                            {if isset($insights['ratings'][$i])}
                                <div class="middle">
                                    <div class="bar-container">
                                        <div class="bar-{$i}" style="width: {$insights['ratings'][$i]['width']}%;"></div>
                                    </div>
                                </div>
                                <div class="side right">
                                    <div>{$insights['ratings'][$i]['total_rating']}</div>
                                </div>
                            {else}
                                <div class="middle">
                                    <div class="bar-container">
                                        <div class="bar-{$i}" style="width: 0%;"></div>
                                    </div>
                                </div>
                                <div class="side right">
                                    <div>0</div>
                                </div>
                            {/if}
                        {/foreach}
                    </div>
                </div>

                {if count($ratings)}
                    <div class="table-responsive">
                        <table class="table {if $theme_mode_night}table-dark{/if} ratings table-striped table-bordered table-hover js_dataTable">
                            <thead>
                                <tr>
                                    <td>Order ID</td>
                                    <td>Paper Rating</td>
                                    <td>Paper on Time</td>
                                    <td>Date</td>
                                    <td>Actions</td>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach $ratings as $rating}
                                    <tr class="{if $rating.user_type == 'employee'}info{/if}">
                                        <td>
                                            <strong><a target="_blank" href="{$base_uri}/order/{$rating.order_id}" data-ajax="/order/{$rating.order_id}">#{$rating.order_id}</a></strong>
                                        </td>
                                        <td>  
                                            <div class="Rating Rating--labeled" data-star_rating="{$rating.paper_rating}">
                                                <span class="Rating-total">
                                                    <span class="Rating-progress"></span>
                                                </span>
                                            </div>
                                        </td>
                                        <td>
                                            {if $rating.paper_on_time}
                                                <span class="label label-success">Yes</span>
                                            {else}
                                                <span class="label label-danger">No</span>
                                            {/if}
                                        </td>
                                        <td>
                                            <span class="js_moment" data-time="{$rating.date}">{$rating.date}</span>
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$rating.id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    Actions
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$rating.id}">
                                                    <a class="dropdown-item" href="{$base_uri}/feedback/{$rating.id}" data-url="/feedback/{$rating.id}">
                                                        <i class="fa fa-pencil-alt mr5"></i> Edit
                                                    </a>
                                                    <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="rating" data-id="{$rating.id}">
                                                        <i class="fa fa-trash mr5"></i> Delete
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                {/foreach}
                            </tbody>
                        </table>

                        {$pager nofilter}
                    </div>
                {else}
                    <div class="text-center x-muted"> <i class="fa fa-envelope fa-4x"></i>
                        <p class="mb10"><strong>No ratings to show</strong></p>
                    </div>
                {/if}
            </div>

        {elseif $sub_view == "view"}
            <div class="card-body">
                <table width="100%" cellspacing="0" cellpadding="0" border="0" class="table_info ratings">
                    <tbody>
                        <tr class="first">
                            <th>Order ID:</th>
                            <td>
                                <a target="_blank" href="{$base_uri}/order/{$feedback.order_id}">#{$feedback.order_id}</a>
                            </td>
                        </tr>
                        <tr class="first">
                            <th>Customer ID:</th>
                            <td>
                                {if $user.is_sub_admin}
                                    {$feedback.order.customer.id}
                                {else}
                                    <a target="_blank" href="{$base_uri}/customers/edit/{$feedback.order.customer.id}">#{$feedback.order.customer.id}</a>
                                {/if}
                            </td>
                        </tr>
                        <tr>
                            <th>Service Rating:</th>
                            <td>
                                <div class="Rating Rating--labeled" data-star_rating="{$feedback.paper_rating}">
                                    <span class="Rating-total">
                                        <span class="Rating-progress"></span>
                                    </span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>Paper Rating:</th>
                            <td>
                                <div class="Rating Rating--labeled" data-star_rating="{$feedback.service_rating}">
                                    <span class="Rating-total">
                                        <span class="Rating-progress"></span>
                                    </span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>Paper on Time:</th>
                            <td>
                                {if $feedback.paper_on_time}
                                    <span class="label label-success">Yes</span>
                                {else}
                                    <span class="label label-danger">No</span>
                                {/if}
                            </td>
                        </tr>
                        <tr>
                            <th>Comments:</th>
                            <td>{$feedback.comment nofilter}</td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" data-toggle="modal" data-url="#modal-feedback" data-options='{literal}{{/literal}"feedback_id":{$feedback.id}{literal}}{/literal}' class="btn btn-primary">Reply</button>
            </div>
            
        {/if}

    </div> 
{/block}