<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>{$title nofilter}</title>
    <style type="text/css">
        html {
            background: #f1f1f1;
        }
        body {
            color: #555;
            font-family: "Open Sans", Arial,sans-serif;
            margin: 0;
            padding: 0;
        }
        .error-title {
            background: #ce3426;
            color: #fff;
            text-align: center;
            font-size: 34px;
            font-weight: 100;
            line-height: 50px;
            padding: 60px 0;
        }
        .error-message {
            margin: 1em auto;
            padding: 1em 2em;
            max-width: 600px;
            font-size: 1em;
            line-height: 1.8em;
            text-align: center;
        }
        .error-message .code,
        .error-message p {
            margin-top: 0;
            margin-bottom: 1.3em;
        }
        .error-message .code {
            font-family: Consolas, Monaco, monospace;
            background: rgba(0, 0, 0, 0.7);
            padding: 10px;
            color: rgba(255, 255, 255, 0.7);
            word-break: break-all;
            border-radius: 2px;
        }
        h1 {
            font-size: 1.2em;
        }
        
        ul li {
            margin-bottom: 1em;
            font-size: 0.9em;
        }
        a {
            color: #ce3426;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
        .button {
            background: #f7f7f7;
            border: 1px solid #cccccc;
            color: #555;
            display: inline-block;
            text-decoration: none;
            margin: 0;
            padding: 5px 10px;
            cursor: pointer;
            -webkit-border-radius: 3px;
            -webkit-appearance: none;
            border-radius: 3px;
            white-space: nowrap;
            -webkit-box-sizing: border-box;
            -moz-box-sizing:    border-box;
            box-sizing:         border-box;

            -webkit-box-shadow: inset 0 1px 0 #fff, 0 1px 0 rgba(0,0,0,.08);
            box-shadow: inset 0 1px 0 #fff, 0 1px 0 rgba(0,0,0,.08);
            vertical-align: top;
        }

        .button.button-large {
            height: 29px;
            line-height: 28px;
            padding: 0 12px;
        }

        .button:hover,
        .button:focus {
            background: #fafafa;
            border-color: #999;
            color: #222;
            text-decoration: none;
        }

        .button:focus  {
            -webkit-box-shadow: 1px 1px 1px rgba(0,0,0,.2);
            box-shadow: 1px 1px 1px rgba(0,0,0,.2);
        }

        .button:active {
            background: #eee;
            border-color: #999;
            color: #333;
            -webkit-box-shadow: inset 0 2px 5px -3px rgba( 0, 0, 0, 0.5 );
            box-shadow: inset 0 2px 5px -3px rgba( 0, 0, 0, 0.5 );
        }
        .text-left {
            text-align: left;
        }
        .text-center {
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="error-title">{$title nofilter}</div>
    <div class="error-message">{$message nofilter}</div>
</body>
</html>