{$style_tab}

<table style="width: 100%; padding: 15pt 0;">
    <tr>
        <td style="width: 50%; text-align: left;">
            <table style="width: 100%">
                    <tr>
                    {if $employee->is_writer}
                        <td style="font-size: 11pt; color: #000;">Writer #{$employee->id}</td>
                    {elseif $employee->is_editor}
                        <td style="font-size: 11pt; color: #000;">Editor #{$employee->id}</td>
                    {elseif $employee->is_sub_admin}
                        <td style="font-size: 11pt; color: #000;">Order Manager #{$employee->id}</td>
                    {/if}
                </tr>
                <tr>
                    <td style="font-size: 11pt; color: #000">{$employee->first_name|ucfirst} {$employee->last_name|ucfirst}</td>
                </tr>
                <tr>
                    <td style="font-size: 11pt; color: #000">{$employee->email|strtolower}</td>
                </tr>
            </table>
        </td>
    </tr>
</table>

<table class="product" width="100%" cellpadding="4" cellspacing="0">
    <thead>
        <tr>
            <th class="product header small" width="20%">FIN/APPR DATE</th>
            <th class="product header small" width="20%">ORDER</th>
            <th class="product header-right small" width="30%">TRANSACTION TYPE</th>
            <th class="product header-right small" width="30%">AMOUNT</th>
        </tr>
    </thead>

    <tbody>
        {if !isset($payment_request.ordersPresented) || count($payment_request.ordersPresented) == 0}
            <tr class="product" colspan="4">
                <td class="product center">No details</td>
            </tr>
        {else}
            {foreach $payment_request.ordersPresented as $order}
                {cycle values=["color_line_even", "color_line_odd"] assign=bgcolor_class}
                <tr class="product {$bgcolor_class}">
                    <td class="product left">
                        {if $order.status == "10"}
                            {$order.approvedAt|date_format}
                        {elseif $order.status == "11"}
                            {$order.finishedAt|date_format}
                        {/if}
                    </td>
                    
                    <td class="product left">
                        #{$order.id}
                    </td>

                    <td class="product left">
                        {$order.statusTitle}
                        {" - "}
                        {if $order.isProgramming || $order.isCalculations}
                            {$order.serviceTypeTitle}
                        {elseif $order.isArticleWriting}
                            {pluralize('word', $order.words)}
                        {else}
                            {if $order.pages} {pluralize('page', $order.pages)} {/if} 
                            {if $order.slides}, {pluralize('slide', $order.slides)} {/if} 
                            {if $order.charts} {pluralize('chart', $order.charts)} {/if} 
                            {if $order.excel_sheets} {pluralize('excel sheet', $order.excel_sheets)} {/if} 
                        {/if}
                    </td>
                    
                    {if $employee->is_writer}
                        <td class="product bold right text-success">
                            + {$order.writerPayFormatted}
                        </td>
                    {elseif $employee->is_editor}
                        <td class="product bold right text-success">
                            + {$order.editorPayFormatted}
                        </td>
                    {elseif $employee->is_sub_admin}
                        <td class="product bold right text-success">
                            + {$order.orderManagerPayFormatted}
                        </td>
                    {else}
                        <td class="product bold right text-danger">
                            + $0.00
                        </td>
                    {/if}
                </tr>
            {/foreach}
        {/if}

    </tbody>

    <tfoot class="product">
        {if $pay_delivered_orders || $payment_request.done_orders_pay}
            <tr class="separator">
                <th class="right bold" align="right" colspan="3">Completed orders:</th>
                <td class="right text-success bold">
                    + {formatPrice($payment_request.done_orders_pay)}
                </td>
            </tr>
        {/if}

        <tr class="separator">
            <th class="right bold" align="right" colspan="3">Approved orders:</th>
            <td class="right text-success bold">
                + {formatPrice($payment_request.completed_orders_pay)}
            </td>
        </tr>

        {if $payment_request.total_credit || $payment_request.total_fine}
            <tr class="separator">
                <th class="right bold" align="right" colspan="3">Sub Total:</th>
                <td class="right text-success bold">
                    + {formatPrice($payment_request.subtotal_pay)}
                </td>
            </tr>
        {/if}

        {if $payment_request.total_credit}
            <tr class="separator">
                <th class="right bold" align="right" colspan="3">Credit:</th>
                <td class="right text-warning bold">
                    + {formatPrice($payment_request.total_credit)}
                </td>
            </tr>
        {/if}

        {if $payment_request.total_fine}
            <tr class="separator">
                <th class="right bold" align="right" colspan="3">Fine:</th>
                <td class="right text-danger bold">
                    - {formatPrice($payment_request.total_fine)}
                </td>
            </tr>
        {/if}

        <tr class="separator">
            <th class="right bold" align="right" colspan="3">Total:</th>
            <td class="right {if $payment_request.total_pay < 0}text-danger{else}text-success{/if} bold">
                + {formatPrice($payment_request.total_pay)}
            </td>
        </tr>
    </tfoot>

</table>


